<?php //a0f7fad8dd7fcf1d4722dcab224c275d
/** @noinspection all */

namespace App\Events {

    use App\Models\ChatBox;
    use App\Models\User;
    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch($user, $message, $data)
     * @method static PendingBroadcast broadcast($user, $message, $data)
     */
    class MessageReceived {}
    
    /**
     * @method static void dispatch(User $user, ChatBox $message)
     * @method static PendingBroadcast broadcast(User $user, ChatBox $message)
     */
    class MessageSent {}
}

namespace App\Jobs {

    use App\Models\Automation;
    use App\Models\Campaigns;
    use App\Models\Contacts;
    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(Automation $automation, $contacts)
     * @method static void dispatchSync(Automation $automation, $contacts)
     */
    class AutomationJob {}
    
    /**
     * @method static PendingDispatch dispatch($customer_id, $campaign_id, $list, $db_fields, $campaign_fields)
     * @method static void dispatchSync($customer_id, $campaign_id, $list, $db_fields, $campaign_fields)
     */
    class ImportCampaign {}
    
    /**
     * @method static PendingDispatch dispatch(Campaigns $campaign)
     * @method static void dispatchSync(Campaigns $campaign)
     */
    class LoadCampaign {}
    
    /**
     * @method static PendingDispatch dispatch($user_id, $campaign_id, $collection, $db_fields, $campaign_fields)
     * @method static void dispatchSync($user_id, $campaign_id, $collection, $db_fields, $campaign_fields)
     */
    class ScheduleBatchJob {}
    
    /**
     * @method static PendingDispatch dispatch(Campaigns $campaign)
     * @method static void dispatchSync(Campaigns $campaign)
     */
    class ScheduleCampaign {}
    
    /**
     * @method static PendingDispatch dispatch($automation, $contact, $server, $user)
     * @method static void dispatchSync($automation, $contact, $server, $user)
     */
    class SendAutomationMessage {}
    
    /**
     * @method static PendingDispatch dispatch($campaign, Contacts $contact, $server)
     * @method static void dispatchSync($campaign, Contacts $contact, $server)
     */
    class SendMessage {}
    
    /**
     * @method static PendingDispatch dispatch($campaign_id)
     * @method static void dispatchSync($campaign_id)
     */
    class StoreCampaignJob {}
}

namespace Illuminate\Foundation\Console {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(array $data)
     * @method static void dispatchSync(array $data)
     */
    class QueuedCommand {}
}

namespace Illuminate\Foundation\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(array $stubs)
     * @method static PendingBroadcast broadcast(array $stubs)
     */
    class PublishingStubs {}
}

namespace Illuminate\Queue {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Laravel\SerializableClosure\SerializableClosure;
    
    /**
     * @method static PendingDispatch dispatch(SerializableClosure $closure)
     * @method static void dispatchSync(SerializableClosure $closure)
     */
    class CallQueuedClosure {}
}

namespace Maatwebsite\Excel\Jobs {

    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Foundation\Bus\PendingDispatch;
    use Maatwebsite\Excel\Concerns\FromQuery;
    use Maatwebsite\Excel\Concerns\FromView;
    use Maatwebsite\Excel\Files\TemporaryFile;
    
    /**
     * @method static PendingDispatch dispatch(object $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, array $data)
     * @method static void dispatchSync(object $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, array $data)
     */
    class AppendDataToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(FromQuery $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, int $page, int $chunkSize)
     * @method static void dispatchSync(FromQuery $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex, int $page, int $chunkSize)
     */
    class AppendQueryToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(FromView $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex)
     * @method static void dispatchSync(FromView $sheetExport, TemporaryFile $temporaryFile, string $writerType, int $sheetIndex)
     */
    class AppendViewToSheet {}
    
    /**
     * @method static PendingDispatch dispatch(object $export, TemporaryFile $temporaryFile, string $writerType)
     * @method static void dispatchSync(object $export, TemporaryFile $temporaryFile, string $writerType)
     */
    class QueueExport {}
    
    /**
     * @method static PendingDispatch dispatch(ShouldQueue $import = null)
     * @method static void dispatchSync(ShouldQueue $import = null)
     */
    class QueueImport {}
}
