<?php $__env->startSection('title', __('locale.contacts.contact_groups')); ?>

<?php $__env->startSection('vendor-style'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/dataTables.bootstrap5.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/responsive.bootstrap5.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/buttons.bootstrap5.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/extensions/sweetalert2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Basic table -->
    <section id="datatables-basic">
        <div class="mb-3 mt-2">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_contact_group')): ?>
                <div class="btn-group">
                    <button
                            class="btn btn-primary fw-bold dropdown-toggle"
                            type="button"
                            id="bulk_actions"
                            data-bs-toggle="dropdown"
                            aria-expanded="false"
                    >
                        <?php echo e(__('locale.labels.actions')); ?>

                    </button>
                    <div class="dropdown-menu" aria-labelledby="bulk_actions">
                        <a class="dropdown-item bulk-enable" href="#"><i data-feather="check"></i> <?php echo e(__('locale.datatables.bulk_enable')); ?></a>
                        <a class="dropdown-item bulk-disable" href="#"><i data-feather="stop-circle"></i> <?php echo e(__('locale.datatables.bulk_disable')); ?></a>
                        <a class="dropdown-item bulk-delete" href="#"><i data-feather="trash"></i> <?php echo e(__('locale.datatables.bulk_delete')); ?></a>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_contact_group')): ?>
                <div class="btn-group">
                    <a href="<?php echo e(route('customer.contacts.create')); ?>" class="btn btn-success waves-light waves-effect fw-bold mx-1"> <?php echo e(__('locale.buttons.add_new')); ?> <i data-feather="plus-circle"></i></a>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_contact_group')): ?>
                <div class="btn-group">
                    <a href="<?php echo e(route('customer.contacts.export')); ?>" class="btn btn-info waves-light waves-effect fw-bold"> <?php echo e(__('locale.buttons.export')); ?> <i data-feather="file-text"></i></a>
                </div>
            <?php endif; ?>

        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <table class="table datatables-basic">
                        <thead>
                        <tr>
                            <th></th>
                            <th></th>
                            <th><?php echo e(__('locale.labels.id')); ?></th>
                            <th><?php echo e(__('locale.labels.name')); ?> </th>
                            <th><?php echo e(__('locale.menu.Contacts')); ?></th>
                            <th><?php echo e(__('locale.labels.last_import_date')); ?></th>
                            <th><?php echo e(__('locale.labels.created_at')); ?></th>
                            <th><?php echo e(__('locale.labels.status')); ?></th>
                            <th><?php echo e(__('locale.labels.actions')); ?></th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
    <!--/ Basic table -->


<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-script'); ?>
    
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/jquery.dataTables.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/dataTables.bootstrap5.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/dataTables.responsive.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/responsive.bootstrap5.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.checkboxes.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.buttons.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/buttons.html5.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/dataTables.rowGroup.min.js'))); ?>"></script>

    <script src="<?php echo e(asset(mix('vendors/js/extensions/sweetalert2.all.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/extensions/polyfill.min.js'))); ?>"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    
    <script>
        $(document).ready(function () {
            "use strict"

            //show response message
            function showResponseMessage(data) {

                if (data.status === 'success') {
                    toastr['success'](data.message, '<?php echo e(__('locale.labels.success')); ?>!!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                    dataListView.draw();
                } else if (data.status === 'error') {
                    toastr['error'](data.message, '<?php echo e(__('locale.labels.opps')); ?>!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                    dataListView.draw();
                } else {
                    toastr['warning']("<?php echo e(__('locale.exceptions.something_went_wrong')); ?>", '<?php echo e(__('locale.labels.warning')); ?>!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                }
            }

            // init table dom
            let Table = $("table");

            // init list view datatable
            let dataListView = $('.datatables-basic').DataTable({

                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "<?php echo e(route('customer.contacts.search')); ?>",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "<?php echo e(csrf_token()); ?>"}
                },
                "columns": [
                    {"data": 'responsive_id', orderable: false, searchable: false},
                    {"data": "uid"},
                    {"data": "uid"},
                    {"data": "name"},
                    {"data": "contacts", orderable: false, searchable: false},
                    {"data": "updated_at"},
                    {"data": "created_at"},
                    {"data": "status"},
                    {"data": "action", orderable: false, searchable: false}
                ],

                searchDelay: 1500,
                columnDefs: [
                    {
                        // For Responsive
                        className: 'control',
                        orderable: false,
                        responsivePriority: 2,
                        targets: 0
                    },
                    {
                        // For Checkboxes
                        targets: 1,
                        orderable: false,
                        responsivePriority: 3,
                        render: function (data) {
                            return (
                                '<div class="form-check"> <input class="form-check-input dt-checkboxes" type="checkbox" value="" id="' +
                                data +
                                '" /><label class="form-check-label" for="' +
                                data +
                                '"></label></div>'
                            );
                        },
                        checkboxes: {
                            selectAllRender:
                                '<div class="form-check"> <input class="form-check-input" type="checkbox" value="" id="checkboxSelectAll" /><label class="form-check-label" for="checkboxSelectAll"></label></div>',
                            selectRow: true
                        }
                    },
                    {
                        // Avatar image/badge, Name and post
                        targets: 3,
                        responsivePriority: 1,
                        render: function (data, type, full) {
                            return (
                                '<a href="' + full['show'] + '">' + full['name'] + '</a>'
                            );
                        }
                    },
                    {
                        // Actions
                        targets: -1,
                        title: '<?php echo e(__('locale.labels.actions')); ?>',
                        orderable: false,
                        render: function (data, type, full) {

                            let $actions = '';

                            if(full['can_create']){
                                $actions += '<a href="' + full['new_contact'] + '" class="text-info me-1" data-bs-toggle="tooltip" data-bs-placement="top" title="' + full['new_contact_label'] + '">' +
                                    feather.icons['plus-circle'].toSvg({class: 'font-medium-4'}) +
                                    '</a>';
                            }

                            if(full['can_update']){
                                $actions += '<a href="' + full['show'] + '" class="text-primary me-1" data-bs-toggle="tooltip" data-bs-placement="top" title=' + full['show_label'] + '>' +
                                    feather.icons['edit'].toSvg({class: 'font-medium-4'}) +
                                    '</a>';
                            }

                            if(full['can_delete']){
                                $actions +='<span class="action-delete text-danger cursor-pointer" data-bs-toggle="tooltip" data-bs-placement="top" title=' + full['delete'] + ' data-id=' + full['uid'] + '>' +
                                    feather.icons['trash'].toSvg({class: 'font-medium-4'}) +
                                    '</span>';
                            }

                            return (
                                '<span class="action-copy text-success me-1" data-value='+full['name']+' data-bs-toggle="tooltip" data-bs-placement="top" title=' + full['copy'] + ' data-id=' + full['uid'] + '>' +
                                feather.icons['copy'].toSvg({class: 'font-medium-4'}) +
                                '</span>' + $actions
                            );
                        }
                    }
                ],
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',

                language: {
                    paginate: {
                        // remove previous & next text from pagination
                        previous: '&nbsp;',
                        next: '&nbsp;'
                    },
                    sLengthMenu: "_MENU_",
                    sZeroRecords: "<?php echo e(__('locale.datatables.no_results')); ?>",
                    sSearch: "<?php echo e(__('locale.datatables.search')); ?>",
                    sProcessing: "<?php echo e(__('locale.datatables.processing')); ?>",
                    sInfo: "<?php echo e(__('locale.datatables.showing_entries', ['start' => '_START_', 'end' => '_END_', 'total' => '_TOTAL_'])); ?>"
                },
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal({
                            header: function (row) {
                                let data = row.data();
                                return 'Details of ' + data['name'];
                            }
                        }),
                        type: 'column',
                        renderer: function (api, rowIdx, columns) {
                            let data = $.map(columns, function (col) {
                                return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                    ? '<tr data-dt-row="' +
                                    col.rowIdx +
                                    '" data-dt-column="' +
                                    col.columnIndex +
                                    '">' +
                                    '<td>' +
                                    col.title +
                                    ':' +
                                    '</td> ' +
                                    '<td>' +
                                    col.data +
                                    '</td>' +
                                    '</tr>'
                                    : '';
                            }).join('');

                            return data ? $('<table class="table"/>').append('<tbody>' + data + '</tbody>') : false;
                        }
                    }
                },
                aLengthMenu: [[10, 20, 50, 100], [10, 20, 50, 100]],
                select: {
                    style: "multi"
                },
                order: [[2, "desc"]],
                displayLength: 10,
            });


            Table.delegate(".get_status", "click", function () {
                let group_id = $(this).data('id');
                $.ajax({
                    url: "<?php echo e(url('contacts')); ?>" + '/' + group_id + '/active',
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (data) {
                        showResponseMessage(data);
                    }
                });
            });

            // On copy
            Table.delegate(".action-copy", "click", function (e) {
                e.stopPropagation();
                let id = $(this).data('id');
                let group_name = $(this).data('value')
                Swal.fire({
                    title: "<?php echo e(__('locale.contacts.new_contact_group')); ?>",
                    text: "<?php echo e(__('locale.contacts.what_would_you_like_to_name_your_group')); ?>",
                    input: 'text',
                    inputValue: 'Copy of ' + group_name,
                    inputAttributes: {
                        autocapitalize: 'off'
                    },
                    showCancelButton: true,
                    cancelButtonText:"<?php echo e(__('locale.buttons.cancel')); ?>",
                    cancelButtonAriaLabel: "<?php echo e(__('locale.buttons.cancel')); ?>",
                    confirmButtonText: feather.icons['copy'].toSvg({ class: 'font-medium-1 me-50' }) + "<?php echo e(__('locale.labels.copy')); ?>",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function (result) {
                    if (result.value) {
                        $.ajax({
                            url: "<?php echo e(url('contacts')); ?>" + '/' + id + '/copy',
                            type: "POST",
                            data: {
                                _method: 'POST',
                                group_name: result.value,
                                _token: "<?php echo e(csrf_token()); ?>"
                            },
                            success: function (data) {
                                showResponseMessage(data);
                            },
                            error: function (reject) {
                                if (reject.status === 422) {
                                    let errors = reject.responseJSON.errors;
                                    $.each(errors, function (key, value) {
                                        toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                            closeButton: true,
                                            positionClass: 'toast-top-right',
                                            progressBar: true,
                                            newestOnTop: true,
                                            rtl: isRtl
                                        });
                                    });
                                } else {
                                    toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                        closeButton: true,
                                        positionClass: 'toast-top-right',
                                        progressBar: true,
                                        newestOnTop: true,
                                        rtl: isRtl
                                    });
                                }
                            }
                        })
                    }
                })
            });

            // On Delete
            Table.delegate(".action-delete", "click", function (e) {
                e.stopPropagation();
                let id = $(this).data('id');
                Swal.fire({
                    title: "<?php echo e(__('locale.labels.are_you_sure')); ?>",
                    text: "<?php echo e(__('locale.labels.able_to_revert')); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "<?php echo e(__('locale.labels.delete_it')); ?>",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function (result) {
                    if (result.value) {
                        $.ajax({
                            url: "<?php echo e(url('contacts')); ?>" + '/' + id,
                            type: "POST",
                            data: {
                                _method: 'DELETE',
                                _token: "<?php echo e(csrf_token()); ?>"
                            },
                            success: function (data) {
                                showResponseMessage(data);
                            },
                            error: function (reject) {
                                if (reject.status === 422) {
                                    let errors = reject.responseJSON.errors;
                                    $.each(errors, function (key, value) {
                                        toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                            closeButton: true,
                                            positionClass: 'toast-top-right',
                                            progressBar: true,
                                            newestOnTop: true,
                                            rtl: isRtl
                                        });
                                    });
                                } else {
                                    toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                        positionClass: 'toast-top-right',
                                        containerId: 'toast-top-right',
                                        progressBar: true,
                                        closeButton: true,
                                        newestOnTop: true
                                    });
                                }
                            }
                        })
                    }
                })
            });


            //Bulk Enable
            $(".bulk-enable").on('click', function (e) {
                e.preventDefault();

                Swal.fire({
                    title: "<?php echo e(__('locale.labels.are_you_sure')); ?>",
                    text: "<?php echo e(__('locale.contacts.enable_contact_groups')); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "<?php echo e(__('locale.labels.enable_selected')); ?>",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,

                }).then(function (result) {
                    if (result.value) {
                        let group_ids = [];
                        let rows_selected = dataListView.column(1).checkboxes.selected();

                        $.each(rows_selected, function (index, rowId) {
                            group_ids.push(rowId)
                        });

                        if (group_ids.length > 0) {

                            $.ajax({
                                url: "<?php echo e(route('customer.contacts.batch_action')); ?>",
                                type: "POST",
                                data: {
                                    _token: "<?php echo e(csrf_token()); ?>",
                                    action: 'enable',
                                    ids: group_ids
                                },
                                success: function (data) {
                                    showResponseMessage(data);
                                },
                                error: function (reject) {
                                    if (reject.status === 422) {
                                        let errors = reject.responseJSON.errors;
                                        $.each(errors, function (key, value) {
                                            toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                        });
                                    } else {
                                        toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                            closeButton: true,
                                            positionClass: 'toast-top-right',
                                            progressBar: true,
                                            newestOnTop: true,
                                            rtl: isRtl
                                        });
                                    }
                                }
                            })
                        } else {
                            toastr['warning']("<?php echo e(__('locale.labels.at_least_one_data')); ?>", "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    }
                })
            });

            //Bulk disable
            $(".bulk-disable").on('click', function (e) {

                e.preventDefault();

                Swal.fire({
                    title: "<?php echo e(__('locale.labels.are_you_sure')); ?>",
                    text: "<?php echo e(__('locale.contacts.disable_contact_groups')); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "<?php echo e(__('locale.labels.disable_selected')); ?>",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function (result) {
                    if (result.value) {
                        let group_ids = [];
                        let rows_selected = dataListView.column(1).checkboxes.selected();

                        $.each(rows_selected, function (index, rowId) {
                            group_ids.push(rowId)
                        });

                        if (group_ids.length > 0) {

                            $.ajax({
                                url: "<?php echo e(route('customer.contacts.batch_action')); ?>",
                                type: "POST",
                                data: {
                                    _token: "<?php echo e(csrf_token()); ?>",
                                    action: 'disable',
                                    ids: group_ids
                                },
                                success: function (data) {
                                    showResponseMessage(data);
                                },
                                error: function (reject) {
                                    if (reject.status === 422) {
                                        let errors = reject.responseJSON.errors;
                                        $.each(errors, function (key, value) {
                                            toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                        });
                                    } else {
                                        toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                            closeButton: true,
                                            positionClass: 'toast-top-right',
                                            progressBar: true,
                                            newestOnTop: true,
                                            rtl: isRtl
                                        });
                                    }
                                }
                            })
                        } else {
                            toastr['warning']("<?php echo e(__('locale.labels.at_least_one_data')); ?>", "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }

                    }
                })
            });


            //Bulk Delete
            $(".bulk-delete").on('click', function (e) {

                e.preventDefault();

                Swal.fire({
                    title: "<?php echo e(__('locale.labels.are_you_sure')); ?>",
                    text: "<?php echo e(__('locale.contacts.delete_contact_groups')); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "<?php echo e(__('locale.labels.delete_selected')); ?>",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function (result) {
                    if (result.value) {
                        let group_ids = [];
                        let rows_selected = dataListView.column(1).checkboxes.selected();

                        $.each(rows_selected, function (index, rowId) {
                            group_ids.push(rowId)
                        });

                        if (group_ids.length > 0) {

                            $.ajax({
                                url: "<?php echo e(route('customer.contacts.batch_action')); ?>",
                                type: "POST",
                                data: {
                                    _token: "<?php echo e(csrf_token()); ?>",
                                    action: 'destroy',
                                    ids: group_ids
                                },
                                success: function (data) {
                                    showResponseMessage(data);
                                },
                                error: function (reject) {
                                    if (reject.status === 422) {
                                        let errors = reject.responseJSON.errors;
                                        $.each(errors, function (key, value) {
                                            toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                        });
                                    } else {
                                        toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                            closeButton: true,
                                            positionClass: 'toast-top-right',
                                            progressBar: true,
                                            newestOnTop: true,
                                            rtl: isRtl
                                        });
                                    }
                                }
                            })
                        } else {
                            toastr['warning']("<?php echo e(__('locale.labels.at_least_one_data')); ?>", "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }

                    }
                })
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/contactGroups/index.blade.php ENDPATH**/ ?>