<?php use App\Library\Tool;use App\Models\Campaigns;use App\Models\Plan;use App\Models\Reports;use App\Models\User;use App\Models\Invoices;use App\Models\SendingServer; ?>


<?php $__env->startSection('title', __('locale.menu.Dashboard')); ?>


<?php $__env->startSection('vendor-style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/charts/apexcharts.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/extensions/tether-theme-arrows.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/extensions/tether.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/extensions/shepherd.min.css'))); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/charts/chart-apex.css'))); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section>

        <?php if(!file_exists(storage_path('cronJobAvailable'))): ?>
            <div class="alert alert-warning" role="alert">
                <h4 class="alert-heading text-uppercase">Cron Job or Schedule task not available</h4>
                <div class="alert-body">
                    <p>Kindly ensure that the cron job or schedule task is enabled to facilitate the importing of
                        contacts, sending campaigns, and all other background-related tasks. Please navigate to <a
                                class="text-decoration-underline " href="<?php echo e(route('admin.settings.general')); ?>"><i>Settings
                                > All Settings > Cron jobs</i></a> for more details. </p>
                </div>
            </div>
        <?php endif; ?>




































































































































































        <div class="row match-height">

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><sup><?php echo e($customerCounts->active); ?></sup>
                                / <?php echo e($customerCounts->total); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.menu.Customers')); ?></p>
                        </div>

                        <a href="<?php echo e(route('admin.customers.index')); ?>">
                            <div class="avatar bg-light-primary p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="users" class="font-medium-5"></i>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><sup><?php echo e($planCounts->active); ?></sup>
                                / <?php echo e($planCounts->total); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.menu.Plan')); ?></p>
                        </div>

                        <a href="<?php echo e(route('admin.plans.index')); ?>">
                            <div class="avatar bg-light-success p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="credit-card" class="font-medium-5"></i>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><?php echo e(Reports::count()); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.labels.sms_send')); ?></p>
                        </div>

                        <a href="<?php echo e(route('admin.reports.all')); ?>">
                            <div class="avatar bg-light-danger p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="message-square" class="font-medium-5"></i>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><?php echo e(Campaigns::count()); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.labels.campaigns_send')); ?></p>
                        </div>

                        <a href="<?php echo e(route('admin.reports.campaigns')); ?>">
                            <div class="avatar bg-light-info p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="send" class="font-medium-5"></i>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
            </div>

        </div>

        <div class="row match-height">

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><sup><?php echo e($subscriptionCounts->active); ?></sup>
                                / <?php echo e($subscriptionCounts->total); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.menu.Subscriptions')); ?></p>
                        </div>

                        <a href="<?php echo e(route('admin.subscriptions.index')); ?>">
                            <div class="avatar bg-light-success p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="credit-card" class="font-medium-5"></i>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
            </div>





















            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0">
                                <sup><?php echo e(Invoices::where('status', '!=', Invoices::STATUS_PAID)->count()); ?></sup>
                                / <?php echo e(Invoices::where('status', Invoices::STATUS_PAID)->count()); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.menu.Invoices')); ?></p>
                        </div>
                        <a href="<?php echo e(route('admin.invoices.index')); ?>">
                            <div class="avatar bg-light-primary p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="shopping-cart" class="font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>



















        </div>

        <div class="row match-height">

            <div class="col-lg-6 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-end">
                        <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.customers_growth')); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body pb-0">
                            <div id="customer-growth"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-end">
                        <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_reports')); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body pb-0">
                            <div id="sms-reports"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row match-height">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-end">
                        <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.revenue_this_month')); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body pb-0">
                            <div id="revenue-chart"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row match-height">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0"><?php echo e(__('locale.labels.recent_sender_id_requests')); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="table-responsive mt-1">
                            <table class="table table-hover-animation mb-0">
                                <thead>
                                <tr>
                                    <th style="width: 15%"><?php echo e(__('locale.labels.sender_id')); ?></th>
                                    <th><?php echo e(__('locale.labels.name')); ?></th>
                                    <th><?php echo e(__('locale.menu.Customer')); ?></th>
                                    <th><?php echo e(__('locale.plans.price')); ?></th>
                                    <th><?php echo e(__('locale.plans.validity')); ?></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $sender_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $senderid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <a href="<?php echo e(route('admin.senderid.show', $senderid->uid)); ?>"><?php echo e($senderid->uid); ?></a>
                                        </td>
                                        <td><?php echo e($senderid->sender_id); ?></td>
                                        <td>
                                            <a href=<?php echo e(route('admin.customers.show', $senderid->user->uid)); ?>><?php echo e($senderid->user->displayName()); ?></a>
                                        </td>
                                        <td><?php echo e(Tool::format_price($senderid->price, $senderid->currency->format)); ?></td>
                                        <td><?php echo e($senderid->displayFrequencyTime()); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php $__currentLoopData = $smsTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($type == 'plain'): ?>
                <div class="row match-height">
                    <!-- Revenue Card -->
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.'.$type.'_sms')])); ?></h4>
                            </div>
                            <div class="card-body">
                                <div id="<?php echo e($type); ?>_sms_data"></div>
                            </div>
                        </div>
                    </div>
                    <!--/ Revenue Card -->

                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    
    <script src="<?php echo e(asset(mix('vendors/js/charts/apexcharts.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/extensions/tether.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/extensions/shepherd.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>
    <!-- Page js files -->


    <script>


        $(window).on("load", function () {

            let $primary = '#7367F0';
            let $strok_color = '#b9c3cd';
            let $label_color = '#e7eef7';
            let $purple = '#df87f2';
            let $textMutedColor = '#b9b9c3';
            let $stroke_color_2 = '#d0ccff';

            let $plainSmsData = document.querySelector('#plain_sms_data');
            let $voiceSmsData = document.querySelector('#voice_sms_data');
            let $mmsSmsData = document.querySelector('#mms_sms_data');
            let $whatsappSmsData = document.querySelector('#whatsapp_sms_data');
            let $viberSmsData = document.querySelector('#viber_sms_data');
            let $otpSmsData = document.querySelector('#otp_sms_data');

            function createChartOptions(height, xAxis, dataSet) {
                return {
                    chart: {
                        height: height,
                        toolbar: {show: false},
                        zoom: {enabled: false},
                        type: 'line',
                        offsetX: -10
                    },
                    stroke: {
                        curve: 'smooth',
                        dashArray: [0, 5, 12],
                        width: [5, 7, 5]
                    },
                    grid: {
                        borderColor: $label_color,
                        padding: {
                            top: -20,
                            bottom: -10,
                            left: 20
                        }
                    },
                    legend: {
                        show: false
                    },
                    colors: [$stroke_color_2, $strok_color, $purple],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            shade: 'dark',
                            inverseColors: false,
                            gradientToColors: [window.colors.solid.primary, $strok_color, $stroke_color_2],
                            shadeIntensity: 1,
                            type: 'horizontal',
                            opacityFrom: 1,
                            opacityTo: 1,
                            stops: [0, 100, 100, 100]
                        }
                    },
                    markers: {
                        size: 0,
                        hover: {
                            size: 5
                        }
                    },
                    xaxis: {
                        labels: {
                            style: {
                                colors: $textMutedColor,
                                fontSize: '1rem'
                            }
                        },
                        axisTicks: {
                            show: false
                        },
                        categories: xAxis,
                        axisBorder: {
                            show: false
                        },
                        tickPlacement: 'on'
                    },
                    yaxis: {
                        tickAmount: 5,
                        labels: {
                            style: {
                                colors: $textMutedColor,
                                fontSize: '1rem'
                            },
                            formatter: function (val) {
                                return val > 999 ? (val / 1000).toFixed(0) + 'k' : val;
                            }
                        }
                    },
                    tooltip: {
                        x: {show: false}
                    },
                    series: dataSet
                };
            }

// Instantiate the charts
            let plainSmsData = new ApexCharts($plainSmsData, createChartOptions(240, <?php echo $charts['plain']->xAxis(); ?>, <?php echo $charts['plain']->dataSet(); ?>));
            plainSmsData.render();

            let voiceSmsData = new ApexCharts($voiceSmsData, createChartOptions(240, <?php echo $charts['voice']->xAxis(); ?>, <?php echo $charts['voice']->dataSet(); ?>));
            voiceSmsData.render();

            let mmsSmsData = new ApexCharts($mmsSmsData, createChartOptions(240, <?php echo $charts['mms']->xAxis(); ?>, <?php echo $charts['mms']->dataSet(); ?>));
            mmsSmsData.render();

            let whatsappSmsData = new ApexCharts($whatsappSmsData, createChartOptions(240, <?php echo $charts['whatsapp']->xAxis(); ?>, <?php echo $charts['whatsapp']->dataSet(); ?>));
            whatsappSmsData.render();

            let viberSmsData = new ApexCharts($viberSmsData, createChartOptions(240, <?php echo $charts['viber']->xAxis(); ?>, <?php echo $charts['viber']->dataSet(); ?>));
            viberSmsData.render();

            let otpSmsData = new ApexCharts($otpSmsData, createChartOptions(240, <?php echo $charts['otp']->xAxis(); ?>, <?php echo $charts['otp']->dataSet(); ?>));
            otpSmsData.render();

            // revenue chart
            // -----------------------------

            let revenueChartOptions = {
                chart: {
                    height: 270,
                    toolbar: {show: false},
                    type: 'line',
                    dropShadow: {
                        enabled: true,
                        top: 20,
                        left: 2,
                        blur: 6,
                        opacity: 0.20
                    },
                },
                stroke: {
                    curve: 'smooth',
                    width: 4,
                },
                grid: {
                    borderColor: $label_color,
                },
                legend: {
                    show: false,
                },
                colors: [$purple],
                fill: {
                    type: 'gradient',
                    gradient: {
                        shade: 'dark',
                        inverseColors: false,
                        gradientToColors: [$primary],
                        shadeIntensity: 1,
                        type: 'horizontal',
                        opacityFrom: 1,
                        opacityTo: 1,
                        stops: [0, 100, 100, 100]
                    },
                },
                markers: {
                    size: 0,
                    hover: {
                        size: 5
                    }
                },
                xaxis: {
                    labels: {
                        style: {
                            colors: $strok_color,
                        }
                    },
                    axisTicks: {
                        show: false,
                    },
                    categories: <?php echo $charts['plain']->xAxis(); ?>,
                    axisBorder: {
                        show: false,
                    },
                    tickPlacement: 'on',
                    type: 'string'
                },
                yaxis: {
                    tickAmount: 5,
                    labels: {
                        style: {
                            color: $strok_color,
                        },
                        formatter: function (val) {
                            return val > 999 ? (val / 1000).toFixed(1) + 'k' : val.toFixed(1);
                        }
                    }
                },
                tooltip: {
                    x: {show: false}
                },
                series: <?php echo $revenue_chart->dataSet(); ?>


            }

            let revenueChart = new ApexCharts(
                document.querySelector("#revenue-chart"),
                revenueChartOptions
            );

            revenueChart.render();

        });


        // Client growth Chart
        // ----------------------------------

        let clientGrowthChartoptions = {
            chart: {
                stacked: true,
                type: 'bar',
                toolbar: {show: false},
                height: 290,
            },
            plotOptions: {
                bar: {
                    columnWidth: '70%'
                }
            },
            colors: ['#7367F0'],
            series: <?php echo $customer_growth->dataSet(); ?>,
            grid: {
                borderColor: '#e7eef7',
                padding: {
                    left: 0,
                    right: 0
                }
            },
            legend: {
                show: true,
                position: 'top',
                horizontalAlign: 'left',
                offsetX: 0,
                fontSize: '14px',
                markers: {
                    radius: 50,
                    width: 10,
                    height: 10,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                labels: {
                    style: {
                        colors: '#b9c3cd',
                    }
                },
                axisTicks: {
                    show: false,
                },
                categories: <?php echo $customer_growth->xAxis(); ?>,
                axisBorder: {
                    show: false,
                },
            },
            yaxis: {
                tickAmount: 5,
                labels: {
                    style: {
                        color: '#b9c3cd',
                    },
                    formatter: function (val) {
                        return val.toFixed(1)
                    }
                }
            },
            tooltip: {
                x: {show: false}
            },
        }

        let clientGrowthChart = new ApexCharts(
            document.querySelector("#customer-growth"),
            clientGrowthChartoptions
        );

        clientGrowthChart.render();


        // sms history Chart
        // -----------------------------

        let smsHistoryChartoptions = {
            chart: {
                type: 'pie',
                height: 325,
                dropShadow: {
                    enabled: false,
                    blur: 5,
                    left: 1,
                    top: 1,
                    opacity: 0.2
                },
                toolbar: {
                    show: false
                }
            },
            labels: ["<?php echo e(__('locale.labels.delivered')); ?>", "<?php echo e(__('locale.labels.failed')); ?>"],
            series: <?php echo $sms_history->dataSet(); ?>,
            dataLabels: {
                enabled: false
            },
            legend: {show: false},
            stroke: {
                width: 5
            },
            colors: ['#7367F0', '#EA5455'],
            fill: {
                type: 'gradient',
                gradient: {
                    gradientToColors: ['#9c8cfc', '#f29292']
                }
            }
        }

        let smsHistoryChart = new ApexCharts(
            document.querySelector("#sms-reports"),
            smsHistoryChartoptions
        );

        smsHistoryChart.render();


    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>