<?php $__env->startSection('title', __('locale.labels.checkout')); ?>

<?php $__env->startSection('vendor-style'); ?>
    <!-- vendor css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/wizard/bs-stepper.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/select/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <!-- Page css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/forms/form-wizard.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!-- Modern Horizontal Wizard -->
    <section class="modern-horizontal-wizard">
        <form action="<?php echo e(route('customer.numbers.pay', $number->uid)); ?>" method="post">
            <?php echo csrf_field(); ?>

            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="alert-body">
                            <?php echo e($error); ?>

                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <div class="bs-stepper wizard-modern modern-wizard-example">
                <div class="bs-stepper-header">

                    <div class="step" data-target="#cart" role="tab" id="cart-trigger">
                        <button type="button" class="step-trigger">
                        <span class="bs-stepper-box">
                            <i data-feather="shopping-cart" class="font-medium-3"></i>
                        </span>
                            <span class="bs-stepper-label">
                            <span class="bs-stepper-title"><?php echo e(__('locale.labels.cart')); ?></span>
                            <span class="bs-stepper-subtitle"><?php echo e(__('locale.phone_numbers.buy_number')); ?> </span>
                        </span>
                        </button>
                    </div>
                    <div class="line">
                        <i data-feather="chevron-right" class="font-medium-2"></i>
                    </div>


                    <div class="step" data-target="#address" role="tab" id="address-trigger">
                        <button type="button" class="step-trigger">
                        <span class="bs-stepper-box">
                            <i data-feather="map-pin" class="font-medium-3"></i>
                        </span>
                            <span class="bs-stepper-label">
                            <span class="bs-stepper-title"><?php echo e(__('locale.labels.address')); ?></span>
                            <span class="bs-stepper-subtitle"><?php echo e(__('locale.labels.billing_address')); ?></span>
                        </span>
                        </button>
                    </div>
                    <div class="line">
                        <i data-feather="chevron-right" class="font-medium-2"></i>
                    </div>


                    <div class="step" data-target="#payment" role="tab" id="payment-trigger">
                        <button type="button" class="step-trigger">
                        <span class="bs-stepper-box">
                            <i data-feather="credit-card" class="font-medium-3"></i>
                        </span>
                            <span class="bs-stepper-label">
                            <span class="bs-stepper-title"><?php echo e(__('locale.labels.payment')); ?></span>
                            <span class="bs-stepper-subtitle"><?php echo e(__('locale.labels.pay_payment')); ?></span>
                        </span>
                        </button>
                    </div>
                </div>


                <div class="bs-stepper-content">

                    <div id="cart" class="content" role="tabpanel" aria-labelledby="cart-trigger">
                        <div class="content-header">
                            <h5 class="mb-0"><?php echo e(__('locale.phone_numbers.buy_number')); ?></h5>
                            <small><?php echo e(__('locale.phone_numbers.buy_number')); ?> <?php echo e($number->number); ?></small>
                        </div>
                        <div class="row mt-1 mb-1">

                            <h5><?php echo e(__('locale.phone_numbers.payment_for_number')); ?>: <span class="text-primary"><?php echo e($number->number); ?></span></h5>
                            <h5><?php echo e(__('locale.labels.frequency')); ?>: <span class="text-primary"><?php echo e($number->displayFrequencyTime()); ?></span></h5>
                            <h5><?php echo e(__('locale.plans.price')); ?>: <span class="text-primary"> <?php echo e(\App\Library\Tool::format_price($number->price, $number->currency->format)); ?> </span></h5>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button class="btn btn-outline-secondary btn-prev" disabled>
                                <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                            </button>
                            <button class="btn btn-primary btn-next" type="button">
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.next')); ?></span>
                                <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                            </button>
                        </div>
                    </div>

                    <div id="address" class="content" role="tabpanel" aria-labelledby="address-trigger">
                        <div class="content-header">
                            <h5 class="mb-0"><?php echo e(__('locale.labels.address')); ?></h5>
                            <small><?php echo e(__('locale.labels.billing_address')); ?></small>
                        </div>
                        <div class="row">

                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="first_name" class="required form-label"><?php echo e(__('locale.labels.first_name')); ?></label>
                                    <input type="text" id="first_name" class="form-control required" name="first_name" value="<?php echo e(Auth::user()->first_name); ?>">
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="last_name"><?php echo e(__('locale.labels.last_name')); ?></label>
                                    <input type="text" id="last_name" class="form-control" name="last_name" value="<?php echo e(Auth::user()->last_name); ?>">
                                </div>
                            </div>


                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="email" class="required form-label"><?php echo e(__('locale.labels.email')); ?></label>
                                    <input type="email" id="email" class="form-control required" name="email" value="<?php echo e(Auth::user()->email); ?>">
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="phone" class="required form-label"><?php echo e(__('locale.labels.phone')); ?></label>
                                    <input type="number" id="phone" class="form-control required" name="phone" value="<?php echo e(Auth::user()->customer->phone); ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="address" class="required form-label"><?php echo e(__('locale.labels.address')); ?></label>
                                    <input type="text" id="address" class="form-control required" name="address" value="<?php echo e(Auth::user()->customer->address); ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="city" class="required form-label"><?php echo e(__('locale.labels.city')); ?></label>
                                    <input type="text" id="city" class="form-control required" name="city" value="<?php echo e(Auth::user()->customer->city); ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="postcode" class="form-label"><?php echo e(__('locale.labels.postcode')); ?></label>
                                    <input type="text" id="postcode" class="form-control" name="postcode" value="<?php echo e(Auth::user()->customer->postcode); ?>">
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="mb-1">
                                    <label for="country" class="required form-label"><?php echo e(__('locale.labels.country')); ?></label>
                                    <select class="form-select select2" id="country" name="country">
                                        <?php $__currentLoopData = \App\Helpers\Helper::countries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country['name']); ?>" <?php echo e(Auth::user()->customer->country == $country['name'] ? 'selected': null); ?>> <?php echo e($country['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button class="btn btn-primary btn-prev" type="button">
                                <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                            </button>
                            <button class="btn btn-primary btn-next" type="button">
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.next')); ?></span>
                                <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                            </button>
                        </div>
                    </div>

                    <div id="payment" class="content" role="tabpanel" aria-labelledby="payment-trigger">
                        <div class="content-header">
                            <h5 class="mb-0"><?php echo e(__('locale.labels.payment_options')); ?></h5>
                            <small><?php echo e(__('locale.payment_gateways.click_on_correct_option')); ?></small>
                        </div>
                        <div class="row mb-2 mt-2 ">
                            <ul class="other-payment-options list-unstyled">

                                <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="py-50">
                                        <div class="form-check">
                                            <input type="radio" id="<?php echo e($method->type); ?>" value="<?php echo e($method->type); ?>" name="payment_methods" class="form-check-input"/>
                                            <label class="form-check-label" for="<?php echo e($method->type); ?>"> <?php echo e($method->name); ?> </label>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </div>
                        <div class="d-flex justify-content-between">
                            <button class="btn btn-primary btn-prev" type="button">
                                <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                            </button>

                            <button class="btn btn-success btn-submit" type="submit"><?php echo e(__('locale.labels.checkout')); ?></button>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </section>
    <!-- /Modern Horizontal Wizard -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <!-- vendor files -->
    <script src="<?php echo e(asset(mix('vendors/js/forms/wizard/bs-stepper.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/forms/select/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <!-- Page js files -->
    <script src="<?php echo e(asset(mix('js/scripts/forms/form-wizard.js'))); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/Numbers/checkout.blade.php ENDPATH**/ ?>