<?php use App\Library\Tool; ?>


<?php $__env->startSection('title', __('locale.menu.Dashboard')); ?>

<?php $__env->startSection('vendor-style'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/charts/apexcharts.css'))); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-style'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/pages/dashboard-ecommerce.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/charts/chart-apex.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <section>

        <div class="row match-height">

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0">

                                <?php
                                    $campaigns = \App\Models\Campaigns::where('user_id', Auth::user()->id);
                                    $totalCamp = $campaigns->count();
                                    $deliveredCamp = $campaigns->where('status', '!=', \App\Models\Campaigns::STATUS_DONE)->count();
                                ?>

                                <sup><?php echo e($deliveredCamp); ?></sup>
                                / <?php echo e($totalCamp); ?></h2>
                            <p class="card-text"><?php echo e(str_plural(__('locale.menu.Campaigns'))); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.reports.campaigns')); ?>">
                            <div class="avatar bg-light-info p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="pie-chart" class="text-info font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0">

                                <sup><?php echo e($deliveredCount); ?></sup>
                                / <?php echo e($total_sms_sent); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.labels.delivered')); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.reports.all')); ?>">
                            <div class="avatar bg-light-success p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="phone-outgoing" class="text-success font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0">

                                <sup><?php echo e($undeliveredCount); ?></sup>
                                / <?php echo e($total_sms_sent); ?></h2>
                            <p class="card-text"><?php echo e(__('locale.labels.failed')); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.reports.all')); ?>">
                            <div class="avatar bg-light-danger p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="x-square" class="text-danger font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><?php echo e(Auth::user()->customer->smsTemplateCounts()); ?></h2>
                            <p class="card-text"><?php echo e(str_plural(__('locale.permission.sms_template'))); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.templates.index')); ?>">
                            <div class="avatar bg-light-warning p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="inbox" class="text-warning font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

        </div>

        <div class="row match-height">

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <?php if(Auth::user()->customer->activeSubscription() != null): ?>
                            <div>
                                <h2 class="fw-bolder mb-0"> <?php echo e(Auth::user()->customer->listsCount() != null ? Tool::format_number(Auth::user()->customer->listsCount()): 0); ?></h2>
                                <p class="card-text"><?php echo e(__('locale.contacts.contact_groups')); ?></p>
                            </div>
                        <?php else: ?>
                            <div>
                                <h2 class="fw-bolder mb-0"> 0</h2>
                                <p class="card-text"><?php echo e(__('locale.contacts.contact_groups')); ?></p>
                            </div>
                        <?php endif; ?>
                        <a href="<?php echo e(route('customer.contacts.index')); ?>">
                            <div class="avatar bg-light-primary p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="users" class="text-primary font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <?php if(Auth::user()->customer->activeSubscription() != null): ?>
                            <div>
                                <h2 class="fw-bolder mb-0"><?php echo e(Auth::user()->customer->subscriberCounts() != null ? Tool::format_number(Auth::user()->customer->subscriberCounts()) : 0); ?></h2>
                                <p class="card-text"><?php echo e(__('locale.menu.Contacts')); ?></p>
                            </div>
                        <?php else: ?>
                            <div>
                                <h2 class="fw-bolder mb-0">0</h2>
                                <p class="card-text"><?php echo e(__('locale.menu.Contacts')); ?></p>
                            </div>
                        <?php endif; ?>
                        <a href="<?php echo e(route('customer.contacts.index')); ?>">
                            <div class="avatar bg-light-success p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="user" class="text-success font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0">
                                <sup><?php echo e(\App\Models\Invoices::where('user_id', Auth::user()->id)->where('status', \App\Models\Invoices::STATUS_UNPAID)->orWhere('status', \App\Models\Invoices::STATUS_PENDING)->count()); ?></sup>
                                / <?php echo e(\App\Models\Invoices::where('user_id', Auth::user()->id)->count()); ?></h2>
                            <p class="card-text"><?php echo e(str_plural(__('locale.menu.Invoices'))); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.subscriptions.index')); ?>">
                            <div class="avatar bg-light-info p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="shopping-cart" class="text-info font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="fw-bolder mb-0"><?php echo e(Auth::user()->customer->blacklistCounts()); ?></h2>
                            <p class="card-text"><?php echo e(str_plural(__('locale.menu.Blacklist'))); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.blacklists.index')); ?>">
                            <div class="avatar bg-light-danger p-50 m-0">
                                <div class="avatar-content">
                                    <i data-feather="user-x" class="text-danger font-medium-5"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row match-height">
            <div class="col-lg-9 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header"></div>
                    <div class="card-body">
                        <h3 class="text-primary"><?php echo e(\App\Helpers\Helper::greetingMessage()); ?></h3>
                        <p class="font-medium-2 mt-2"><?php echo e(__('locale.description.dashboard', ['brandname' => config('app.name')])); ?></p>

                        <div class="row d-flex justify-content-center">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms_quick_send')): ?>
                                <div class="col-lg-3 col-sm-6 col-6 pb-1">
                                    <a href="<?php echo e(route('customer.sms.quick_send')); ?>"
                                       class="btn btn-sm btn-warning w-100"><i
                                                data-feather="send"></i> <?php echo e(__('locale.menu.Quick Send')); ?></a>
                                </div>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms_campaign_builder')): ?>
                                <div class="col-lg-4 col-sm-6 col-6 pb-1">
                                    <a href="<?php echo e(route('customer.sms.campaign_builder')); ?>"
                                       class="btn btn-sm btn-success w-100"><i
                                                data-feather="server"></i> <?php echo e(__('locale.menu.Campaign Builder')); ?></a>
                                </div>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms_bulk_messages')): ?>
                                <div class="col-lg-3 col-sm-6 col-6 pb-1">
                                    <a href="<?php echo e(route('customer.sms.import')); ?>" class="btn btn-sm btn-primary w-100"><i
                                                data-feather="file-text"></i> <?php echo e(__('locale.menu.Send Using File')); ?></a>
                                </div>
                            <?php endif; ?>

                        </div>

                    </div>
                </div>
            </div>






























            <div class="col-lg-3 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-end">
                        <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_reports')); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body p-0">
                            <div id="sms-reports" class="my-2"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['quick_send', 'sms_campaign_builder', 'sms_bulk_messages'])): ?>
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.plain_sms')])); ?></h4>
                        </div>
                        <div class="card-body">
                            <div id="plain_sms_data"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['voice_campaign_builder', 'voice_quick_send', 'voice_bulk_messages'])): ?>
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.voice_sms')])); ?></h4>
                        </div>
                        <div class="card-body">
                            <div id="voice_sms_data"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['mms_campaign_builder', 'mms_quick_send', 'mms_bulk_messages'])): ?>
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.mms_sms')])); ?></h4>
                        </div>
                        <div class="card-body">
                            <div id="mms_sms_data"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['whatsapp_campaign_builder', 'whatsapp_quick_send', 'whatsapp_bulk_messages'])): ?>
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.whatsapp_sms')])); ?></h4>
                        </div>
                        <div class="card-body">
                            <div id="whatsapp_sms_data"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['viber_campaign_builder', 'viber_quick_send', 'viber_bulk_messages'])): ?>
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.viber_sms')])); ?></h4>
                        </div>
                        <div class="card-body">
                            <div id="viber_sms_data"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['otp_campaign_builder', 'otp_quick_send', 'otp_bulk_messages'])): ?>
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title text-uppercase"><?php echo e(__('locale.labels.sms_statistics', ['sms_type' => __('locale.labels.otp_sms')])); ?></h4>
                        </div>
                        <div class="card-body">
                            <div id="otp_sms_data"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


    </section>
    <!-- Dashboard Analytics end -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-script'); ?>
    
    <script src="<?php echo e(asset(mix('vendors/js/charts/apexcharts.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>

    <script>
        function percentage(partialValue, totalValue) {
            return (100 * partialValue) / totalValue;
        }

        $(window).on("load", function () {

            let $strok_color = "#b9c3cd";
            let $label_color = "#e7eef7";
            let $purple = "#df87f2";
            let $textMutedColor = '#b9b9c3';
            let $stroke_color_2 = '#d0ccff';

            let $plainSmsData = document.querySelector('#plain_sms_data');
            let $voiceSmsData = document.querySelector('#voice_sms_data');
            let $mmsSmsData = document.querySelector('#mms_sms_data');
            let $whatsappSmsData = document.querySelector('#whatsapp_sms_data');
            let $viberSmsData = document.querySelector('#viber_sms_data');
            let $otpSmsData = document.querySelector('#otp_sms_data');


            function createChartOptions(height, xAxis, dataSet) {
                return {
                    chart: {
                        height: height,
                        toolbar: {show: false},
                        zoom: {enabled: false},
                        type: 'line',
                        offsetX: -10
                    },
                    stroke: {
                        curve: 'smooth',
                        dashArray: [0, 5, 12],
                        width: [5, 7, 5]
                    },
                    grid: {
                        borderColor: $label_color,
                        padding: {
                            top: -20,
                            bottom: -10,
                            left: 20
                        }
                    },
                    legend: {
                        show: false
                    },
                    colors: [$stroke_color_2, $strok_color, $purple],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            shade: 'dark',
                            inverseColors: false,
                            gradientToColors: [window.colors.solid.primary, $strok_color, $stroke_color_2],
                            shadeIntensity: 1,
                            type: 'horizontal',
                            opacityFrom: 1,
                            opacityTo: 1,
                            stops: [0, 100, 100, 100]
                        }
                    },
                    markers: {
                        size: 0,
                        hover: {
                            size: 5
                        }
                    },
                    xaxis: {
                        labels: {
                            style: {
                                colors: $textMutedColor,
                                fontSize: '1rem'
                            }
                        },
                        axisTicks: {
                            show: false
                        },
                        categories: xAxis,
                        axisBorder: {
                            show: false
                        },
                        tickPlacement: 'on'
                    },
                    yaxis: {
                        tickAmount: 5,
                        labels: {
                            style: {
                                colors: $textMutedColor,
                                fontSize: '1rem'
                            },
                            formatter: function (val) {
                                return val > 999 ? (val / 1000).toFixed(0) + 'k' : val;
                            }
                        }
                    },
                    tooltip: {
                        x: {show: false}
                    },
                    series: dataSet
                };
            }

            // Instantiate the charts
            let plainSmsData = new ApexCharts($plainSmsData, createChartOptions(240, <?php echo $charts['plain']->xAxis(); ?>, <?php echo $charts['plain']->dataSet(); ?>));
            plainSmsData.render();

            let voiceSmsData = new ApexCharts($voiceSmsData, createChartOptions(240, <?php echo $charts['voice']->xAxis(); ?>, <?php echo $charts['voice']->dataSet(); ?>));
            voiceSmsData.render();

            let mmsSmsData = new ApexCharts($mmsSmsData, createChartOptions(240, <?php echo $charts['mms']->xAxis(); ?>, <?php echo $charts['mms']->dataSet(); ?>));
            mmsSmsData.render();

            let whatsappSmsData = new ApexCharts($whatsappSmsData, createChartOptions(240, <?php echo $charts['whatsapp']->xAxis(); ?>, <?php echo $charts['whatsapp']->dataSet(); ?>));
            whatsappSmsData.render();

            let viberSmsData = new ApexCharts($viberSmsData, createChartOptions(240, <?php echo $charts['viber']->xAxis(); ?>, <?php echo $charts['viber']->dataSet(); ?>));
            viberSmsData.render();

            let otpSmsData = new ApexCharts($otpSmsData, createChartOptions(240, <?php echo $charts['otp']->xAxis(); ?>, <?php echo $charts['otp']->dataSet(); ?>));
            otpSmsData.render();


            // sms history Chart
            // -----------------------------

            let smsHistoryChartoptions = {
                chart: {
                    type: "pie",
                    height: 180,
                    toolbar: {
                        show: false
                    }
                },
                labels: ["<?php echo e(__('locale.labels.delivered')); ?>", "<?php echo e(__('locale.labels.failed')); ?>"],
                series: <?php echo $sms_history->dataSet(); ?>,
                dataLabels: {
                    enabled: false
                },
                legend: {show: false},
                stroke: {
                    width: 4
                },
                colors: ["#7367F0", "#EA5455"]
            };

            let smsHistoryChart = new ApexCharts(
                document.querySelector("#sms-reports"),
                smsHistoryChartoptions
            );

            smsHistoryChart.render();

        });

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/dashboard.blade.php ENDPATH**/ ?>