<?php
    $configData = Helper::applClasses();
?>
<div class="main-menu menu-fixed <?php echo e((($configData['theme'] === 'dark') || ($configData['theme'] === 'semi-dark')) ? 'menu-dark' : 'menu-light'); ?> menu-accordion menu-shadow" data-scroll-to-active="true">
    <div class="navbar-header">
        <ul class="nav navbar-nav flex-row">

            <?php if(Auth::user()->active_portal == 'customer' && Auth::user()->is_customer == 1 && Auth::user()->customer->activeSubscription()): ?>
                <li class="nav-item me-auto">
                    <a class="navbar-brand" href="<?php echo e(route('user.home')); ?>">
                        <div class="brand-logo">
                            <img src="<?php echo e(asset(config('app.logo'))); ?>" alt="<?php echo e(config('app.name')); ?>"/>
                        </div>
                    </a>
                </li>

            <?php else: ?>
                <li class="nav-item me-auto">
                    <a class="navbar-brand" href="<?php echo e(route('admin.home')); ?>">
                        <div class="brand-logo">
                            <img src="<?php echo e(asset(config('app.logo'))); ?>" alt="<?php echo e(config('app.name')); ?>"/>
                        </div>
                    </a>
                </li>
            <?php endif; ?>

            <li class="nav-item nav-toggle">
                <a class="nav-link modern-nav-toggle pe-0" data-toggle="collapse">
                    <i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i>
                    <i class="d-none d-xl-block collapse-toggle-icon font-medium-4 text-primary" data-feather="disc" data-ticon="disc"></i>
                </a>
            </li>
        </ul>
    </div>

    <div class="shadow-bottom"></div>

    <div class="main-menu-content">
        <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
            
            <?php if(isset($menuData[0])): ?>
                <?php
                    if (auth()->user()->active_portal == 'admin'){
                        $sidebarMenu = $menuData['0']->admin;
                     }else{
                        $sidebarMenu = $menuData['0']->customer;
                     }
                ?>

                <?php $__currentLoopData = $sidebarMenu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($menu->navheader)): ?>
                        <li class="navigation-header">
                            <span><?php echo e($menu->navheader); ?></span>
                            <i data-feather="more-horizontal"></i>
                        </li>
                    <?php else: ?>
                        
                        <?php
                            $custom_classes = "";
                            if(isset($menu->classlist)) {
                            $custom_classes = $menu->classlist;
                            }
                            $translation = "";
                            if(isset($menu->i18n)){
                            $translation = $menu->i18n;
                            }
                            $permission = explode('|', $menu->access);
                        ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any($permission, auth()->user())): ?>

                            <li class="nav-item <?php echo e(isset($menu->slug) &&  str_contains(request()->path(),$menu->slug) ? 'active' : ''); ?> <?php echo e($custom_classes); ?>">
                                <a href="<?php echo e($menu->url); ?>" class="d-flex align-items-center">
                                    <i data-feather="<?php echo e($menu->icon); ?>"></i>
                                    <span class="menu-title text-truncate" data-i18n="<?php echo e($translation); ?>"><?php echo e(__('locale.menu.'.$menu->name)); ?></span>
                                </a>
                                <?php if(isset($menu->submenu)): ?>
                                    <?php echo $__env->make('panels/submenu', ['menu' => $menu->submenu], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            
        </ul>
    </div>
</div>
<!-- END: Main Menu-->
<?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/panels/sidebar.blade.php ENDPATH**/ ?>