<?php $__env->startSection('title', __('locale.menu.Dashboard')); ?>

<?php $__env->startSection('vendor-style'); ?>
    <!-- vendor css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/charts/apexcharts.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/pickers/flatpickr/flatpickr.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/select/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/forms/pickers/form-flat-pickr.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/charts/chart-apex.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- apex charts section start -->
    <section id="apexchart">
        <div class="row match-height">
            <!-- Area Chart starts -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex flex-sm-row flex-column justify-content-md-between align-items-start justify-content-start">
                        <div>
                            <h4 class="card-title"><?php echo e(__('locale.labels.sms_count')); ?></h4>
                            <span class="card-subtitle text-muted"><?php echo e(__('locale.labels.sms_statistics_different_channel')); ?></span>
                        </div>


                        <form action="<?php echo e(route('admin.reports.dashboard')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="d-flex align-items-center">

                                <div class="customer me-2">

                                    <select class="form-select select2" id="user_id" name="user_id">
                                        <option value="0"><?php echo e(__('locale.labels.select_customer')); ?></option>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if(isset($request->user_id) && $request->user_id == $customer->id): ?> selected <?php endif; ?> value="<?php echo e($customer->id); ?>"><?php echo e($customer->displayName()); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>


                                <select id="date-range-select" name="dateRangeSelect" class="form-select">
                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="today"): ?> selected <?php endif; ?> value="today">
                                        <?php echo e(__('locale.labels.today')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="yesterday"): ?> selected <?php endif; ?> value="yesterday">
                                        <?php echo e(__('locale.labels.yesterday')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="this-week"): ?> selected <?php endif; ?> value="this-week">
                                        <?php echo e(__('locale.labels.this_week')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="last-week"): ?> selected <?php endif; ?> value="last-week">
                                        <?php echo e(__('locale.labels.last_week')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="last-7-days"): ?> selected <?php endif; ?> value="last-7-days">
                                        <?php echo e(__('locale.labels.last_7_days')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="last-30-days"): ?> selected <?php endif; ?> value="last-30-days">
                                        <?php echo e(__('locale.labels.last_30_days')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="last-60-days"): ?> selected <?php endif; ?> value="last-60-days">
                                        <?php echo e(__('locale.labels.last_60_days')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="last-90-days"): ?> selected <?php endif; ?> value="last-90-days">
                                        <?php echo e(__('locale.labels.last_90_days')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="this-year"): ?> selected <?php endif; ?> value="this-year">
                                        <?php echo e(__('locale.labels.this_year')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="last-year"): ?> selected <?php endif; ?> value="last-year">
                                        <?php echo e(__('locale.labels.last_year')); ?>

                                    </option>

                                    <option <?php if(isset($request->dateRangeSelect) && $request->dateRangeSelect =="period"): ?> selected <?php endif; ?> value="period">
                                        <?php echo e(__('locale.labels.custom_period')); ?>

                                    </option>
                                </select>


                                <input type="text" name="dateRange" value="<?php echo $request->dateRange ?? date('Y-m-d'); ?>" class="form-control flat-picker bg-transparent border-0 shadow-none" placeholder="YYYY-MM-DD" id="date-range"/>


                                <button class="btn btn-sm" type="submit"><i class="text-primary" data-feather="search"></i></button>
                            </div>
                        </form>

                    </div>
                    <div class="card-body">
                        <div id="sms-unit-count"></div>
                    </div>
                </div>
            </div>

                <?php if(count($reports) > 0): ?>
                    <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card card-statistics">
                            <div class="card-header">
                                <h4 class="card-title"><?php echo e(ucfirst($report->sms_type)); ?> <?php echo e(__('locale.labels.sms_statistics')); ?></h4>
                            </div>
                            <div class="card-body statistics-body">
                                <div class="row">
                                    <div class="col-md-3 col-sm-6 col-12 mb-2 mb-md-0">
                                        <div class="d-flex flex-row">
                                            <div class="avatar bg-light-primary me-2">
                                                <div class="avatar-content">
                                                    <i data-feather="send" class="avatar-icon"></i>
                                                </div>
                                            </div>
                                            <div class="my-auto">
                                                <h4 class="fw-bolder mb-0"><?php echo e($report->total_sms); ?></h4>
                                                <p class="card-text font-small-3 mb-0"><?php echo e(__('locale.labels.total')); ?> <?php echo e(__('locale.labels.sms')); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-6 col-12 mb-2 mb-md-0">
                                        <div class="d-flex flex-row">
                                            <div class="avatar bg-light-info me-2">
                                                <div class="avatar-content">
                                                    <i data-feather="dollar-sign" class="avatar-icon"></i>
                                                </div>
                                            </div>
                                            <div class="my-auto">
                                                <h4 class="fw-bolder mb-0"><?php echo e($report->total_cost); ?></h4>
                                                <p class="card-text font-small-3 mb-0"><?php echo e(__('locale.labels.total')); ?> <?php echo e(__('locale.labels.cost')); ?></p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3 col-sm-6 col-12">
                                        <div class="d-flex flex-row">
                                            <div class="avatar bg-light-success me-2">
                                                <div class="avatar-content">
                                                    <i data-feather="check-square" class="avatar-icon"></i>
                                                </div>
                                            </div>
                                            <div class="my-auto">
                                                <h4 class="fw-bolder mb-0"><?php echo e($report->delivered_sms); ?></h4>
                                                <p class="card-text font-small-3 mb-0"><?php echo e(__('locale.labels.delivered')); ?></p>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                        <div class="d-flex flex-row">
                                            <div class="avatar bg-light-danger me-2">
                                                <div class="avatar-content">
                                                    <i data-feather="x-square" class="avatar-icon"></i>
                                                </div>
                                            </div>
                                            <div class="my-auto">
                                                <h4 class="fw-bolder mb-0"><?php echo e($report->not_delivered_sms); ?></h4>
                                                <p class="card-text font-small-3 mb-0"><?php echo e(__('locale.labels.failed')); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="alert alert-primary" role="alert">
                        <div class="alert-body"><strong><?php echo e(__('locale.labels.opps')); ?></strong> <?php echo e(__('locale.datatables.no_results')); ?></div>
                    </div>
                <?php endif; ?>


            </div>
            <!-- Area Chart ends -->
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <!-- vendor files -->
    <script src="<?php echo e(asset(mix('vendors/js/charts/apexcharts.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/pickers/flatpickr/flatpickr.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/forms/select/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script>


        $(function () {
            'use strict';

            // Basic Select2 select
            $(".select2").each(function () {
                let $this = $(this);
                $this.wrap('<div class="position-relative"></div>');
                $this.select2({
                    // the following code is used to disable x-scrollbar when click in select input and
                    // take 100% width in responsive also
                    dropdownAutoWidth: true,
                    width: '100%',
                    dropdownParent: $this.parent()
                });
            });


            // Initialize flatpickr date range picker
            $("#date-range").flatpickr({
                mode: "range",
                dateFormat: "Y-m-d",
                onClose: function (selectedDates, dateStr, instance) {
                    // Hide the flatpickr date range picker after selection
                    instance.close();
                }
            });

            // Show flatpickr date range picker on select option
            $("#date-range-select").on("change", function () {
                const optionValue = $(this).val();
                const range = [];
                const today = new Date();
                const dayOfWeek = today.getDay();

                switch (optionValue) {
                    case "today":
                        range.push(new Date());
                        break;
                    case "yesterday":
                        range.push(new Date());
                        range.push(new Date());
                        range[0].setDate(range[0].getDate() - 1);
                        range[1].setDate(range[1].getDate() - 1);
                        break;
                    case "this-week":
                        range.push(new Date(today.getFullYear(), today.getMonth(), today.getDate() - dayOfWeek));
                        range.push(new Date(today.getFullYear(), today.getMonth(), today.getDate() - dayOfWeek + 6));
                        break;
                    case "last-week":
                        range.push(new Date(today.getFullYear(), today.getMonth(), today.getDate() - dayOfWeek - 7));
                        range.push(new Date(today.getFullYear(), today.getMonth(), today.getDate() - dayOfWeek - 1));
                        break;
                    case "last-7-days":
                        range.push(new Date());
                        range.push(new Date());
                        range[0].setDate(range[0].getDate() - 7);
                        break;
                    case "last-30-days":
                    case 'period':
                        range.push(new Date());
                        range.push(new Date());
                        range[0].setDate(range[0].getDate() - 30);
                        break;
                    case "last-60-days":
                        range.push(new Date());
                        range.push(new Date());
                        range[0].setDate(range[0].getDate() - 60);
                        break;
                    case "last-90-days":
                        range.push(new Date());
                        range.push(new Date());
                        range[0].setDate(range[0].getDate() - 90);
                        break;
                    case "this-year":
                        range.push(new Date(new Date().getFullYear(), 0, 1));
                        range.push(new Date(new Date().getFullYear(), 11, 31));
                        break;
                    case "last-year":
                        range.push(new Date(new Date().getFullYear() - 1, 0, 1));
                        range.push(new Date(new Date().getFullYear() - 1, 11, 31));
                        break;
                }

                // Set the selected range in the flatpickr date range picker
                $("#date-range").flatpickr({
                    defaultDate: range,
                    mode: 'range'
                });
            });


            let isRtl = $('html').attr('data-textdirection') === 'rtl',
                chartColors = {
                    column: {
                        unicode: '#00FFD2',
                        whatsapp: '#FFFFD2',
                        mms: '#C5FAD5',
                        voice: '#AA96DA',
                        sms: '#F7C5CC',
                        bg: '#f8d3ff'
                    },

                };


            // Area Chart
            // --------------------------------------------------------------------
            let areaChartEl = document.querySelector('#sms-unit-count'),
                areaChartConfig = {
                    chart: {
                        height: 400,
                        type: 'bar',
                        stacked: true,
                        parentHeightOffset: 0,
                        toolbar: {
                            show: true
                        }
                    },
                    plotOptions: {
                        bar: {
                            columnWidth: '15%',
                            colors: {
                                backgroundBarColors: [
                                    chartColors.column.bg,
                                    chartColors.column.bg,
                                    chartColors.column.bg,
                                    chartColors.column.bg,
                                    chartColors.column.bg
                                ],
                                backgroundBarRadius: 10
                            }
                        }
                    },
                    dataLabels: {
                        enabled: false
                    },
                    legend: {
                        show: true,
                        position: 'top',
                        horizontalAlign: 'start'
                    },
                    colors: [chartColors.column.sms, chartColors.column.voice, chartColors.column.mms, chartColors.column.whatsapp, chartColors.column.unicode],
                    stroke: {
                        show: true,
                        colors: ['transparent']
                    },
                    grid: {
                        xaxis: {
                            lines: {
                                show: true
                            }
                        }
                    },
                    series: <?php echo $chart->dataSet(); ?>,
                    xaxis: {
                        categories: <?php echo $chart->xAxis(); ?>,
                    },
                    fill: {
                        opacity: 1
                    },
                    yaxis: {
                        opposite: isRtl
                    }
                };
            if (typeof areaChartEl !== undefined && areaChartEl !== null) {
                let areaChart = new ApexCharts(areaChartEl, areaChartConfig);
                areaChart.render();
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/admin/Reports/dashboard.blade.php ENDPATH**/ ?>