<?php if($contact->cache): ?>
    <div class="row match-height">

        <div class="col-lg-4 col-sm-6 col-12">
            <div class="card">
                <div class="card-header">
                    <div>
                        <h2 class="fw-bolder mb-0"><?php echo e($contact->readCache('TotalSubscribers')); ?></h2>
                        <p class="card-text"><?php echo e(__('locale.labels.total')); ?></p>
                    </div>

                    <div>
                        <i class="font-large-3 text-primary" data-feather="users"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4 col-sm-6 col-12">
            <div class="card">
                <div class="card-header">
                    <div>
                        <h2 class="fw-bolder mb-0"><?php echo e($contact->readCache('SubscribersCount')); ?></h2>
                        <p class="card-text"><?php echo e(__('locale.contacts.active_contacts')); ?></p>
                    </div>

                    <div>
                        <i class="font-large-3 text-success" data-feather="user-check"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4 col-sm-6 col-12">
            <div class="card">
                <div class="card-header">
                    <div>
                        <h2 class="fw-bolder mb-0"><?php echo e($contact->readCache('UnsubscribesCount')); ?></h2>
                        <p class="card-text"><?php echo e(__('locale.contacts.inactive_contacts')); ?></p>
                    </div>
                    <div>
                        <i class="font-large-3 text-danger" data-feather="user-x"></i>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php endif; ?>


<div id="datatables-basic">

    <div class="mb-3 mt-2">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_contact')): ?>
            <div class="btn-group">
                <button
                        class="btn btn-primary fw-bold dropdown-toggle me-1"
                        type="button"
                        id="bulk_actions"
                        data-bs-toggle="dropdown"
                        aria-expanded="false"
                >
                    <?php echo e(__('locale.labels.actions')); ?>

                </button>
                <div class="dropdown-menu" aria-labelledby="bulk_actions">
                    <a class="dropdown-item bulk-subscribe" href="#"><i
                                data-feather="check"></i> <?php echo e(__('locale.labels.subscribe')); ?></a>
                    <a class="dropdown-item bulk-unsubscribe" href="#"><i
                                data-feather="stop-circle"></i> <?php echo e(__('locale.labels.unsubscribe')); ?></a>
                    <a class="dropdown-item bulk-copy" href="#"><i
                                data-feather="copy"></i> <?php echo e(__('locale.buttons.copy')); ?></a>
                    <a class="dropdown-item bulk-move" href="#"><i
                                data-feather="move"></i> <?php echo e(__('locale.buttons.move')); ?></a>
                    <a class="dropdown-item bulk-delete" href="#"><i
                                data-feather="trash"></i> <?php echo e(__('locale.datatables.bulk_delete')); ?></a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_contact')): ?>
            <div class="btn-group">
                <a href="<?php echo e(route('customer.contact.create', $contact->uid)); ?>"
                   class="btn btn-success waves-light waves-effect fw-bold me-1"> <?php echo e(__('locale.buttons.add_new')); ?> <i
                            data-feather="plus-circle"></i></a>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_contact')): ?>
            <div class="btn-group">
                <a href="<?php echo e(route('customer.contact.import', $contact->uid)); ?>"
                   class="btn btn-secondary waves-light waves-effect fw-bold me-1"> <?php echo e(__('locale.buttons.import')); ?> <i
                            data-feather="upload"></i></a>
            </div>

            <div class="btn-group">
                <a href="<?php echo e(route('customer.contact.export', $contact->uid)); ?>"
                   class="btn btn-info waves-light waves-effect fw-bold"> <?php echo e(__('locale.buttons.export')); ?> <i
                            data-feather="download"></i></a>
            </div>
        <?php endif; ?>


    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <table class="table datatables-basic">
                    <thead>
                    <tr>
                        <th></th>
                        <th></th>
                        <th><?php echo e(__('locale.labels.id')); ?></th>
                        <th><?php echo e(__('locale.menu.Contacts')); ?></th>
                        <th><?php echo e(__('locale.labels.updated_at')); ?></th>
                        <th><?php echo e(__('locale.labels.status')); ?></th>
                        <th><?php echo e(__('locale.labels.actions')); ?></th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

</div>
<?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/contactGroups/_contacts.blade.php ENDPATH**/ ?>