<div class="card">
    <div class="card-body py-2 my-25">
        <!-- header section -->
        <div class="d-flex">
            <a href="<?php echo e(route('user.account')); ?>" class="me-25">
                <img src="<?php echo e(route('user.avatar')); ?>" alt="<?php echo e($user->displayName()); ?>"
                     class="uploadedAvatar rounded me-50"
                     height="100"
                     width="100"
                />
            </a>
            <!-- upload and reset button -->
            <div class="d-flex align-items-end mt-75 ms-1">
                <div>
                    <?php echo $__env->make('auth.profile._update_avatar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <button id="remove-avatar" data-id="<?php echo e($user->uid); ?>" class="btn btn-sm btn-danger mb-75 me-75"><i data-feather="trash-2"></i> <?php echo e(__('locale.labels.remove')); ?></button>
                    <p class="mb-0"> <?php echo e(__('locale.customer.profile_image_size')); ?> </p>
                </div>
            </div>
            <!--/ upload and reset button -->
        </div>
        <!--/ header section -->

        <!-- form -->
        <form class="form form-vertical mt-2 pt-50" action="<?php echo e(route('user.account.update')); ?>" method="post">
            <?php echo method_field('PATCH'); ?>
            <?php echo csrf_field(); ?>
            <div class="row">

                <div class="col-12 col-sm-6">
                    <div class="col-12">
                        <div class="mb-1">
                            <label for="email" class="form-label required"><?php echo e(__('locale.labels.email')); ?></label>
                            <input type="email" id="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($user->email); ?>" name="email" required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p><small class="text-danger"><?php echo e($message); ?></small></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 col-sm-6">
                            <div class="mb-1">
                                <label for="first_name" class="form-label required"><?php echo e(__('locale.labels.first_name')); ?></label>
                                <input type="text" id="first_name" class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($user->first_name); ?>" name="first_name" required>
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-12 col-sm-6">
                            <div class="mb-1">
                                <label for="last_name" class="form-label"><?php echo e(__('locale.labels.last_name')); ?></label>
                                <input type="text" id="last_name" class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($user->last_name); ?>" name="last_name">
                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6">
                    <div class="col-12">
                        <div class="mb-1">
                            <label for="timezone" class="required form-label"><?php echo e(__('locale.labels.timezone')); ?></label>
                            <select class="select2 form-select" id="timezone" name="timezone">
                                <?php $__currentLoopData = \App\Library\Tool::allTimeZones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($timezone['zone']); ?>" <?php echo e($user->timezone == $timezone['zone'] ? 'selected': null); ?>> <?php echo e($timezone['text']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php $__errorArgs = ['timezone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p><small class="text-danger"><?php echo e($message); ?></small></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-12">
                        <div class="mb-1">
                            <label for="locale" class="required form-label"><?php echo e(__('locale.labels.language')); ?></label>
                            <select class="select2 form-select" id="locale" name="locale">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($language->code); ?>" <?php echo e($user->locale == $language->code ? 'selected': null); ?>> <?php echo e($language->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php $__errorArgs = ['locale'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p><small class="text-danger"><?php echo e($message); ?></small></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-12 d-flex flex-sm-row flex-column justify-content-end mt-1">
                    <button type="submit" class="btn btn-primary mt-1 me-1"><i data-feather="save"></i> <?php echo e(__('locale.buttons.save_changes')); ?></button>
                </div>

            </div>
        </form>
        <!--/ form -->
    </div>
</div>


<?php if( ! Auth::user()->is_super_admin && config('account.can_delete')): ?>
    <div class="card">
        <div class="card-header border-bottom">
            <h4 class="card-title"><?php echo e(__('locale.auth.delete_account')); ?></h4>
        </div>
        <div class="card-body py-2 my-25">
            <div class="alert alert-warning">
                <h4 class="alert-heading"><?php echo e(__('locale.auth.want_to_delete_your_account')); ?>?</h4>
                <div class="alert-body fw-normal">
                    <?php echo e(__('locale.auth.once_you_delete_your_account')); ?>

                </div>
            </div>

            <form id="formAccountDeactivation" class="validate-form" onsubmit="return false">
                <div class="form-check">
                    <input
                            class="form-check-input"
                            type="checkbox"
                            name="accountActivation"
                            id="accountActivation"
                            data-msg="<?php echo e(__('locale.auth.want_to_delete_your_account')); ?>"
                    />
                    <label class="form-check-label font-small-3" for="accountActivation">
                        <?php echo e(__('locale.auth.confirm_my_account_deactivation')); ?>

                    </label>
                </div>
                <div>
                    <button type="submit" class="btn btn-danger deactivate-account mt-1"><?php echo e(__('locale.auth.deactivate_account')); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/auth/profile/_accounts.blade.php ENDPATH**/ ?>