<?php $__env->startSection('title', __('locale.menu.Update Application')); ?>

<?php $__env->startSection('content'); ?>
    <!-- Basic Vertical form layout section start -->
    <section id="basic-vertical-layouts">
        <div class="row match-height">
            <div class="col-md-7 col-12">

                <div class="card">
                    <div class="card-header"></div>
                    <div class="card-content">
                        <div class="card-body">

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if(Session::get('update_required')): ?>

                                <h4 class="text-danger mb-2">Before update, please take a backup you're all files and database.</h4>

                                <p> Your are currently running on Ultimate SMS <code class="fw-bold"><?php echo e(config('app.version')); ?></code> To upgrade your application, please download the latest build from <a href="https://codecanyon.net/item/ultimate-sms-bulk-sms-application-for-marketing/20062631" target="_blank">codecanyon.net</a> , then you can find the upgrade package located at downloaded folder called <code>3.*.*_update.zip</code>, upload it using the form below.
                                </p>
                                <p>
                                    <?php if(function_exists('ini_get')): ?>
                                        <?php if((int)ini_get('post_max_size') < 120): ?>
                                            Your <code>post_max_size</code> value is: <?php echo e(ini_get('post_max_size')); ?>. Please increase your limit to minimum 120M.<br>

                                        <?php else: ?>
                                            Please make sure the upgrade package file size does not exceed the following upload limit settings. Otherwise, your update will not work:<br><br>
                                            <span class="fw-bold text-danger"><i data-feather="check-square"></i> post_max_size</span> <span class="fw-bold text-primary">256M</span><br>

                                        <?php endif; ?>

                                        <?php if((int)ini_get('upload_max_filesize') < 120): ?>
                                            Your <code>upload_max_filesize</code> value is: <?php echo e(ini_get('upload_max_filesize')); ?>. Please increase your limit to minimum 120M.<br>
                                        <?php else: ?>
                                            <span class="fw-bold text-danger"><i data-feather="check-square"></i> upload_max_filesize</span> <span class="fw-bold text-primary">256M</span><br>

                                        <?php endif; ?>
                                </p>
                            <?php else: ?>
                                <p>Please make sure the upgrade package file size does not exceed the following upload limit settings. Otherwise, your update will not work:<br><br>
                                    <span class="fw-bold text-danger"><i data-feather="check-square"></i> post_max_size</span> <span class="fw-bold text-primary">256M</span><br>
                                    <span class="fw-bold text-danger"><i data-feather="check-square"></i> upload_max_filesize</span> <span class="fw-bold text-primary">256M</span>
                                </p>
                            <?php endif; ?>


                            <form id="fileUploadForm" class="form form-vertical" action="<?php echo e(route('admin.settings.update_application')); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label for="purchase_code" class="required form-label"><?php echo e(__('locale.permission.purchase_code')); ?></label>
                                            <input type="text" id="purchase_code" class="form-control <?php $__errorArgs = ['purchase_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(\App\Helpers\Helper::app_config('license')); ?>" name="purchase_code" required>
                                            <?php $__errorArgs = ['purchase_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback">
                                                <?php echo e($message); ?>

                                            </div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label for="update_file" class="form-label">Update File</label>
                                            <input type="file" name="update_file" class="form-control" id="update_file" accept="zip,application/octet-stream,application/zip,application/x-zip,application/x-zip-compressed"/>
                                            <?php $__errorArgs = ['update_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p><small class="text-danger"> <?php echo e($message); ?></small></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <?php if(Session::get('version')): ?>
                                                <input type="hidden" value="<?php echo e(Session::get('version')); ?>" name="version">
                                                <p><small class="text-primary"> Please upload only <code><?php echo e(Session::get('version')); ?>_update.zip</code> file</small></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1">
                                            <i data-feather="upload"></i> <?php echo e(__('locale.labels.upload')); ?>

                                        </button>
                                    </div>
                                </div>

                                <div class="row" id="progress_bar">
                                    <div class="col-12">
                                        <div class="progress progress-bar-primary">
                                            <div class="progress-bar progress-bar-striped progress-bar-animated"
                                                 role="progressbar"
                                                 aria-valuenow="0"
                                                 aria-valuemin="0"
                                                 aria-valuemax="100"
                                                 style="width: 0"
                                            ></div>
                                        </div>
                                    </div>
                                </div>

                            </form>
                            <?php else: ?>
                                <h3> Your are currently running on Ultimate SMS <code class="fw-bold"><?php echo e(config('app.version')); ?></code></h3>
                                <h4 class="mt-1"><span class="text-primary"> CONGRATULATION!!!</span> You are using latest version</h4>
                                <hr>
                                <a href="<?php echo e(route('admin.settings.check_update')); ?>" class="btn btn-primary"><i data-feather="check-square"></i> Check for Updates</a>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>


        </div>
    </section>
    <!-- // Basic Vertical form layout section end -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/4.3.0/jquery.form.min.js"></script>

    <script>
        let firstInvalid = $('form').find('.is-invalid').eq(0);

        if (firstInvalid.length) {
            $('body, html').stop(true, true).animate({
                'scrollTop': firstInvalid.offset().top - 200 + 'px'
            }, 200);
        }

        let progress_bar = $('#progress_bar');
        progress_bar.hide();

        $('#fileUploadForm').ajaxForm({
            beforeSend: function () {
                let percentage = '0';
            },
            uploadProgress: function (event, position, total, percentComplete) {
                let percentage = percentComplete;
                progress_bar.show();
                $('.progress .progress-bar').css("width", percentage + '%', function () {
                    return $(this).attr("aria-valuenow", percentage) + "%";
                })
            },
            complete: function (data) {
                if (data.status === 200) {
                    toastr['success']("File uploaded. Please don't reload the page until complete. it will take couple of minutes to complete", '<?php echo e(__('locale.labels.success')); ?>!!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });


                    location.reload();

                } else {
                    if (data.status !== 200) {
                        toastr['warning']('Please check your server post_max_size & upload_max_filesize settings value.', '<?php echo e(__('locale.labels.attention')); ?>!!', {
                            closeButton: true,
                            positionClass: 'toast-top-right',
                            progressBar: true,
                            newestOnTop: true,
                        });
                    } else {
                        toastr['warning'](data.responseJSON.message, '<?php echo e(__('locale.labels.attention')); ?>!!', {
                            closeButton: true,
                            positionClass: 'toast-top-right',
                            progressBar: true,
                            newestOnTop: true,
                        });
                    }
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/admin/settings/UpdateApplication/index.blade.php ENDPATH**/ ?>