<?php $__env->startSection('title', __('locale.menu.Payment Gateways')); ?>

<?php $__env->startSection('vendor-style'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/dataTables.bootstrap5.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/responsive.bootstrap5.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/tables/datatable/buttons.bootstrap5.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Basic table -->
    <section id="datatables-basic">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <table class="table datatables-basic">
                        <thead>
                        <tr>
                            <th></th>
                            <th><?php echo e(__('locale.labels.name')); ?></th>
                            <th><?php echo e(__('locale.labels.status')); ?></th>
                            <th><?php echo e(__('locale.labels.actions')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td></td>
                                <td><?php echo e($gateway->name); ?></td>
                                <td>
                                    <div class='form-check form-switch form-check-primary'>
                                        <input type="checkbox" class="form-check-input get_status" id="<?php echo e($gateway->uid); ?>" data-id="<?php echo e($gateway->uid); ?>" name='status' <?php if($gateway->status == true): ?> checked <?php endif; ?>>
                                        <label class="form-check-label" for="<?php echo e($gateway->uid); ?>">
                                            <span class="switch-icon-left"><i data-feather="check"></i></span>
                                            <span class="switch-icon-right"><i data-feather="x"></i></span>
                                        </label>
                                    </div>
                                </td>

                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update payment_gateways')): ?>
                                        <a href="<?php echo e(route('admin.payment-gateways.show', $gateway->uid)); ?>" class='text-primary'><i data-feather="settings" class="feather-20"></i> <?php echo e(__('locale.labels.settings')); ?></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
    <!--/ Basic table -->


<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-script'); ?>
    
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/jquery.dataTables.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/dataTables.bootstrap5.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/dataTables.responsive.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/responsive.bootstrap5.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/datatables.buttons.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/tables/datatable/buttons.html5.min.js'))); ?>"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    
    <script>
        $(document).ready(function () {
            "use strict"

            let Table = $("table");
            //show response message
            function showResponseMessage(data) {

                if (data.status === 'success') {
                    toastr['success'](data.message, '<?php echo e(__('locale.labels.success')); ?>!!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                    dataListView.draw();
                } else if (data.status === 'error') {
                    toastr['error'](data.message, '<?php echo e(__('locale.labels.opps')); ?>!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                    dataListView.draw();
                } else {
                    toastr['warning']("<?php echo e(__('locale.exceptions.something_went_wrong')); ?>", '<?php echo e(__('locale.labels.warning')); ?>!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                }
            }


            let dataListView = $('.datatables-basic').DataTable({

                "processing": true,
                "columns": [
                    {"data": "id", orderable: false, searchable: false},
                    {"data": "name"},
                    {"data": "status"},
                    {"data": "action", orderable: false, searchable: false}
                ],
                columnDefs: [
                    {
                        // For Responsive
                        className: 'control',
                        orderable: false,
                        responsivePriority: 2,
                        targets: 0
                    },
                ],
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',

                language: {
                    paginate: {
                        // remove previous & next text from pagination
                        previous: '&nbsp;',
                        next: '&nbsp;'
                    },
                    sLengthMenu: "_MENU_",
                    sZeroRecords: "<?php echo e(__('locale.datatables.no_results')); ?>",
                    sSearch: "<?php echo e(__('locale.datatables.search')); ?>",
                    sProcessing: "<?php echo e(__('locale.datatables.processing')); ?>",
                    sInfo: "<?php echo e(__('locale.datatables.showing_entries', ['start' => '_START_', 'end' => '_END_', 'total' => '_TOTAL_'])); ?>"
                },
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal({
                            header: function (row) {
                                let data = row.data();
                                return 'Details of ' + data['name'];
                            }
                        }),
                        type: 'column',
                        renderer: function (api, rowIdx, columns) {
                            let data = $.map(columns, function (col) {
                                return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                    ? '<tr data-dt-row="' +
                                    col.rowIdx +
                                    '" data-dt-column="' +
                                    col.columnIndex +
                                    '">' +
                                    '<td>' +
                                    col.title +
                                    ':' +
                                    '</td> ' +
                                    '<td>' +
                                    col.data +
                                    '</td>' +
                                    '</tr>'
                                    : '';
                            }).join('');

                            return data ? $('<table class="table"/>').append('<tbody>' + data + '</tbody>') : false;
                        }
                    }
                },
                aLengthMenu: [[10, 20, 50, 100], [10, 20, 50, 100]],

                order: [[0, "desc"]],
                displayLength: 20,
            });

            //change status
            Table.delegate(".get_status", "click", function () {
                let gateway = $(this).data('id');

                $.ajax({
                    url: "<?php echo e(url(config('app.admin_path').'/payment-gateways')); ?>" + '/' + gateway + '/active',
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (data) {
                        showResponseMessage(data);
                    }
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/admin/settings/PaymentMethods/index.blade.php ENDPATH**/ ?>