<div class="row">
    <div class="col-12">
        <div class="card">
            <table class="table mb-0">
                <thead class="thead-primary">
                <tr>
                    <th scope="col"><?php echo e(__('locale.labels.submitted')); ?></th>
                    <th scope="col"><?php echo e(__('locale.labels.status')); ?></th>
                    <th scope="col"><?php echo e(__('locale.labels.message')); ?></th>
                </tr>
                </thead>
                <tbody>


                <?php if($currentJob): ?>
                    <?php
                        $progress = $contact->getProgress($currentJob);
                    ?>
                    <?php if($progress['status'] == 'failed'): ?>
                        <tr>
                            <td class="text-center" colspan="5">
                                <?php echo e(__('locale.exceptions.something_went_wrong')); ?>

                            </td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <td> <?php echo e(\App\Library\Tool::customerDateTime($currentJob->created_at)); ?> </td>
                            <td> <?php echo $currentJob->getStatus(); ?> </td>
                            <td><?php echo e(strtoupper($progress['message'])); ?></td>
                        </tr>

                    <?php endif; ?>

                <?php else: ?>
                    <tr>
                        <td class="text-center" colspan="5">
                            <?php echo e(__('locale.datatables.no_results')); ?>

                        </td>
                    </tr>
                <?php endif; ?>

                </tbody>
            </table>
        </div>
    </div>
</div>
<?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/contactGroups/_import_history.blade.php ENDPATH**/ ?>