<?php $__env->startSection('title', __('locale.labels.top_up')); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .active_background .card {
            background-color: antiquewhite;
        }

    </style>
    <!-- Basic Vertical form layout section start -->
    <section id="basic-vertical-layouts">
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8 col-12">

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger pt-1">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"> <?php echo e(__('locale.customer.add_unit_to_your_account')); ?> </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="form-body">
                                <form class="form form-vertical" action="<?php echo e(route('user.account.top_up')); ?>"
                                      method="post">
                                    <?php echo csrf_field(); ?>

                                    <div class="row">
                                        <div class="col-3"></div>
                                        <div class="col-6">
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label for="add_unit"
                                                           class="form-label required"><?php echo e(__('locale.labels.amount')); ?></label>
                                                    <div class="input-group input-group-merge mb-2">
                                                        <span class="input-group-text "><?php echo e(str_replace('{PRICE}', '', Auth::user()->customer->subscription->plan->currency->format)); ?></span>
                                                        <input type="number" id="add_unit"
                                                               class="form-control <?php $__errorArgs = ['add_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                               name="add_unit" required>


                                                        <?php $__errorArgs = ['add_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                    <p>
                                                        <small class="text-primary text-uppercase hidden show_units_info"></small>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3"></div>
                                        <div class="col-12">
                                            <div class="row">
                                                <div class="card-header">
                                                    <h4 class="card-title text-uppercase"> Current Plan :<small><?php echo e(Auth::user()->customer->subscription->plan->name); ?></small>
                                                    </h4>
                                                </div>
                                                <div class="card-content">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <?php
                                                                $plan = \App\Models\Plan::where('status', 1)->where('show_in_customer',1)->whereNot('name','demo')->with('plansCoverageCountries')->get();
//                                                                print_r($plan);exit();
                                                            ?>
                                                            <?php if($plan->count() > 0): ?>
                                                                <?php $__currentLoopData = $plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    
                                                                    <div class="col-3">
                                                                        <a class="plan-link" data-cost="<?php echo e($item->price); ?>"
                                                                           data-id="<?php echo e($item->id); ?>">
                                                                            <div class="card border border-primary text-center p-2">
                                                                                <?php
                                                                                    $data = json_decode($item->USpricingCoverage() ,true);
                                                                                    $plain_sms_value = json_decode($data['options'],true); ?>
                                                                                <h2><?php echo e(str_replace('{PRICE}', '', $item->currency->format)); ?> <?php echo e($plain_sms_value['plain_sms']); ?></h2>
                                                                                <span>Per SMS Price</span>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="col-3">
                                                                    <a data-cost="" href="<?php echo e(route('support')); ?>">
                                                                        <div class="card border border-primary text-center p-2">
                                                                            <?php
                                                                                $data = json_decode($item->USpricingCoverage() ,true);
                                                                                $plain_sms_value = json_decode($data['options'],true); ?>
                                                                            <h3>Talk to an expert</h3>
                                                                        </div>
                                                                    </a>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="plan_id" id="plan_id" value="" required>
                                        <div class="col-5">

                                            <input type="hidden" id="sms_unit" name="sms_unit" value="" >

                                            <button type="submit" class="btn btn-primary mb-1">
                                                <i data-feather="plus-square"></i> <?php echo e(__('locale.labels.process_to_pay')); ?>

                                            </button>
                                        </div>
                                        <div class="col-4">
                                            <input type="number" class="form-control" id="sms_counter" readonly
                                                   name="sms_counter" value="" required>
                                        </div>
                                        <div class="col-3">
                                            <h5>Plan:</h5>
                                            <p id="plan_name"></p>

                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>


            </div>
            <div class="col-md-2"></div>

        </div>
    </section>
    <!-- // Basic Vertical form layout section end -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>

    <script>
        let firstInvalid = $('form').find('.is-invalid').eq(0);

        if (firstInvalid.length) {
            $('body, html').stop(true, true).animate({
                'scrollTop': firstInvalid.offset().top - 200 + 'px'
            }, 200);
        }

        function getUnits(amount) {
            $.ajax({
                url: '<?php echo e(route('user.account.get.units')); ?>',
                method: 'POST',
                data: {
                    '_token': '<?php echo e(csrf_token()); ?>',
                    'amount': amount
                },
                success: function (response) {
                    if (response.units) {
                        $('#sms_unit').val(response.price);
                        
                        $('#plan_name').text(response.plan_name);
                        $('#sms_counter').val(response.units);
                        $('#plan_id').val(response.plan_id);
                        // find acnchor tag having data-id = response.plan_id and add active class
                        //also remove from other anchor tags class active
                        $('a').removeClass('active_background');
                        $('a[data-id="' + response.plan_id + '"]').addClass('active_background');
                    } else {
                        $('.show_units_info').text('').addClass('hidden');
                        toastr['warning'](response.error, "<?php echo e(__('locale.labels.attention')); ?>", {
                            closeButton: true,
                            positionClass: 'toast-top-right',
                            progressBar: true,
                            newestOnTop: true,
                            rtl: isRtl
                        });
                        $('#sms_unit').val('');
                        $('#plan_name').text('');
                        $('#sms_counter').val('');
                        $('#add_unit').val('');
                        $('#plan_id').val('');
                        // find acnchor tag having data-id = response.plan_id and add active class
                        //also remove from other anchor tags class active
                        $('a').removeClass('active_background');
                    }
                },
                error: function (error) {
                    toastr['warning'](error.responseText, "<?php echo e(__('locale.labels.attention')); ?>", {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                        rtl: isRtl
                    });
                    $('#sms_unit').val('');
                    $('#plan_name').text('');
                    $('#sms_counter').val('');
                    $('#add_unit').val('');
                    $('#plan_id').val('');
                    // find acnchor tag having data-id = response.plan_id and add active class
                    //also remove from other anchor tags class active
                    $('a').removeClass('active_background');
                }
            });
        }

        let timeoutId;

        $('#add_unit').on('input', function () {
            // Clear the previous timeout
            clearTimeout(timeoutId);

            // Set a new timeout
            timeoutId = setTimeout(function () {
                let enteredAmount = $('#add_unit').val();
                getUnits(enteredAmount);
            }, 10); // Adjust the delay time (in milliseconds) as needed
        });

        $('.plan-link').on('click', function () {
            let amount = $(this).data('cost');
            // set amount in the add_unit input
            $('#add_unit').val(amount);
            getUnits(amount);
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/Accounts/top_up.blade.php ENDPATH**/ ?>