<?php $__env->startSection('title', __('locale.menu.Quick Send')); ?>

<?php $__env->startSection('vendor-style'); ?>
    <!-- vendor css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/select/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>

    <style>
        .customized_select2 .select2-selection--single, .input_sender_id {
            border-left: 0;
            border-radius: 0 4px 4px 0;
            min-height: 2.75rem !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Basic Vertical form layout section start -->
    <section id="basic-vertical-layouts campaign_builder">


        <div class="row">
            <div class="col-md-8 col-12">
                <div class="alert alert-info" role="alert">
                    <div class="alert-body d-flex align-items-center">
                        <i data-feather="info" class="me-50"></i>
                        <span class="text-uppercase"> <?php echo e(__('locale.template_tags.not_work_with_quick_send')); ?></span>
                    </div>
                </div>
            </div>
        </div>


        <div class="row match-height">
            <div class="col-md-8 col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">

                            <form class="form form-vertical" action="<?php echo e(route('customer.sms.quick_send')); ?>"
                                  method="post">
                                <?php echo csrf_field(); ?>
                                <div class="row">

                                    <?php if($sendingServers->count() > 0): ?>
                                        <div class="col-12" style="display: none">
                                            <div class="mb-1">
                                                <label for="sending_server"
                                                       class="form-label required"><?php echo e(__('locale.labels.sending_server')); ?></label>
                                                <select class="select2 form-select rate-calculate-quicksend"
                                                        name="sending_server"
                                                        id="sending_server">
                                                    <?php $__currentLoopData = $sendingServers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($server->sendingServer->plain): ?>
                                                            <option value="<?php echo e($server->sendingServer->id); ?>"> <?php echo e($server->sendingServer->name); ?></option>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <?php $__errorArgs = ['sending_server'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_sender_id')): ?>
                                        <?php if(auth()->user()->customer->getOption('sender_id_verification') == 'yes'): ?>
                                            <div class="col-12">
                                                <p class="text-uppercase"><?php echo e(__('locale.labels.originator')); ?></p>
                                            </div>

                                            <div class="col-md-6 col-12 customized_select2">
                                                <div class="mb-1">
                                                    <label for="sender_id"
                                                           class="form-label"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                                    <div class="input-group">
                                                        <div class="input-group-text">
                                                            <div class="form-check">
                                                                <input type="radio" class="form-check-input sender_id"
                                                                       name="originator" checked value="sender_id"
                                                                       id="sender_id_check"/>
                                                                <label class="form-check-label"
                                                                       for="sender_id_check"></label>
                                                            </div>
                                                        </div>

                                                        <div style="width: 17rem">
                                                            <select class="form-select select2" id="sender_id"
                                                                    name="sender_id">
                                                                <?php $__currentLoopData = $sender_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sender_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($sender_id->sender_id); ?>"> <?php echo e($sender_id->sender_id); ?> </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        <?php else: ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_numbers')): ?>
                                                <div class="col-md-6 col-12 customized_select2">
                                                    <div class="mb-1">
                                                        <label for="sender_id"
                                                               class="form-label"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                                        <div class="input-group">
                                                            <div class="input-group-text">
                                                                <div class="form-check">
                                                                    <input type="radio"
                                                                           class="form-check-input sender_id"
                                                                           name="originator" checked value="sender_id"
                                                                           id="sender_id_check"/>
                                                                    <label class="form-check-label"
                                                                           for="sender_id_check"></label>
                                                                </div>
                                                            </div>

                                                            <div style="width: 17rem">
                                                                <input type="text" id="sender_id"
                                                                       class="form-control input_sender_id <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                       name="sender_id" autofocus>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            <?php else: ?>
                                                <div class="col-12">
                                                    <div class="mb-1">
                                                        <label for="sender_id"
                                                               class="form-label"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                                        <input type="text" id="sender_id"
                                                               class="form-control <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                               name="sender_id">
                                                        <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_numbers')): ?>
                                        <div class="col-md-6 col-12 customized_select2">
                                            <div class="mb-1">
                                                <label for="phone_number"
                                                       class="form-label"><?php echo e(__('locale.menu.Phone Numbers')); ?></label>
                                                <div class="input-group">
                                                    <div class="input-group-text">
                                                        <div class="form-check">
                                                            <input type="radio" class="form-check-input phone_number"
                                                                   value="phone_number" name="originator"
                                                                   id="phone_number_check"/>
                                                            <label class="form-check-label"
                                                                   for="phone_number_check"></label>
                                                        </div>
                                                    </div>
                                                    <div style="width: 17rem">
                                                        <select class="form-select select2 rate-calculate-quicksend"
                                                                disabled id="phone_number"
                                                                name="phone_number">
                                                            <?php $__currentLoopData = $phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($number->number); ?>"> <?php echo e($number->number); ?> </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label class="country_code form-label"
                                                   for="country_code"><?php echo e(__('locale.labels.country_code')); ?></label>
                                            <select class="form-select select2 rate-calculate-quicksend"
                                                    id="country_code" name="country_code">
                                                <option value="0"><?php echo e(__('locale.labels.remaining_in_number')); ?></option>
                                                <?php $__currentLoopData = $coverage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($code->country_id); ?>"
                                                            <?php if($code->country->country_code == $countryCode): ?> selected <?php endif; ?>>
                                                        +<?php echo e($code->country->country_code); ?> </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php $__errorArgs = ['country_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12">

                                        <div class="mb-1">
                                            <label for="recipients"
                                                   class="form-label"><?php echo e(__('locale.labels.manual_input')); ?></label>
                                            <textarea class="form-control rate-calculate-quicksend" id="recipients"
                                                      name="recipients"><?php if(isset($recipient)): ?>
                                                    <?php echo e($recipient); ?>

                                                <?php endif; ?></textarea>
                                            <p><small class="text-uppercase">
                                                    <?php echo e(__('locale.labels.total_number_of_recipients')); ?>:<span
                                                            class="number_of_recipients fw-bold text-success">0</span>
                                                </small></p>
                                            <?php $__errorArgs = ['recipients'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <div class="btn-group btn-group-sm recipients" role="group">
                                                <input type="radio" class="btn-check" name="delimiter" value=","
                                                       id="comma" autocomplete="off" checked/>
                                                <label class="btn btn-outline-primary" for="comma">,
                                                    (<?php echo e(__('locale.labels.comma')); ?>)</label>

                                                <input type="radio" class="btn-check" name="delimiter" value=";"
                                                       id="semicolon" autocomplete="off"/>
                                                <label class="btn btn-outline-primary" for="semicolon">;
                                                    (<?php echo e(__('locale.labels.semicolon')); ?>)</label>

                                                <input type="radio" class="btn-check" name="delimiter" value="|"
                                                       id="bar" autocomplete="off"/>
                                                <label class="btn btn-outline-primary" for="bar">|
                                                    (<?php echo e(__('locale.labels.bar')); ?>)</label>

                                                <input type="radio" class="btn-check" name="delimiter" value="tab"
                                                       id="tab" autocomplete="off"/>
                                                <label class="btn btn-outline-primary"
                                                       for="tab"><?php echo e(__('locale.labels.tab')); ?></label>

                                                <input type="radio" class="btn-check" name="delimiter" value="new_line"
                                                       id="new_line" autocomplete="off"/>
                                                <label class="btn btn-outline-primary"
                                                       for="new_line"><?php echo e(__('locale.labels.new_line')); ?></label>

                                            </div>

                                            <?php $__errorArgs = ['delimiter'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <p>
                                            <small class="text-primary"><?php echo __('locale.description.manual_input'); ?> <?php echo __('locale.contacts.include_country_code_for_successful_import'); ?></small>
                                        </p>
                                    </div>

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label class="sms_template form-label"><?php echo e(__('locale.permission.sms_template')); ?></label>
                                            <select class="form-select select2 rate-calculate-quicksend"
                                                    id="sms_template">
                                                <option><?php echo e(__('locale.labels.select_one')); ?></option>
                                                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($template->id); ?>"><?php echo e($template->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>
                                    </div>

                                    <?php if(config('app.trai_dlt')): ?>
                                        <div class="col-12">
                                            <div class="mb-1">
                                                <label for="dlt_template_id"
                                                       class="form-label required"><?php echo e(__('locale.templates.dlt_template_id')); ?></label>
                                                <input type="text"
                                                       id="dlt_template_id"
                                                       class="form-control <?php $__errorArgs = ['dlt_template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> rate-calculate-quicksend"
                                                       name="dlt_template_id"
                                                       required>
                                                <?php $__errorArgs = ['dlt_template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label for="message"
                                                   class="required form-label"><?php echo e(__('locale.labels.message')); ?></label>
                                            <textarea class="form-control rate-calculate-quicksend" name="message"
                                                      rows="5"
                                                      id="message"></textarea>
                                            <div class="d-flex justify-content-between">
                                                <small class="text-primary text-uppercase text-start"
                                                       id="remaining">160 <?php echo e(__('locale.labels.characters_remaining')); ?></small>
                                                <small class="text-primary text-uppercase text-end"
                                                       id="messages">1 <?php echo e(__('locale.labels.message')); ?> (s)</small>
                                            </div>
                                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                </div>
                                <div class="text-center">
                                    <div class="spinner-grow float-right" role="status" style="display: none">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-2">
                                        <input type="hidden" value="plain" name="sms_type" id="sms_type">
                                        <button id="send_message_button" type="submit"
                                                class="btn btn-primary mr-1 mb-1"><i
                                                    data-feather="send"></i> <?php echo e(__('locale.buttons.send')); ?>

                                        </button>
                                    </div>
                                    <div class="col-8">

                                        <div class=" text-center">
                                            <div class="card-body">
                                                <p id="calculation" class="rounded-text"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-2 " id="recalculate" style="display: none">
                                        <a href="#" id="recalculateLink">Recalculate</a>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- // Basic Vertical form layout section end -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <!-- vendor files -->
    <script src="<?php echo e(asset(mix('vendors/js/forms/select/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset(mix('js/scripts/sms-counter.js'))); ?>"></script>
    <script>
        $(document).ready(function () {
            let typingTimer;
            let doneTypingInterval = 1000; // 2 seconds delay
            $(".sender_id").on("click", function () {
                $("#sender_id").prop("disabled", !this.checked);
                $("#phone_number").prop("disabled", this.checked);
            });

            $(".phone_number").on("click", function () {
                $("#phone_number").prop("disabled", !this.checked);
                $("#sender_id").prop("disabled", this.checked);
            });
            $(".rate-calculate-quicksend").on('keyup change', function () {
                clearTimeout(typingTimer);
                typingTimer = setTimeout(calculateQuickSend, doneTypingInterval);
            });
            $("#recalculateLink").click(function (event) {
                event.preventDefault(); // Prevent default link behavior
                calculateQuickSend(); // Call the calculateQuickSend function
            });

            function calculateQuickSend() {
                $('.spinner-grow').css('display', 'block');
                let sending_server = $('#sending_server').val();
                let messages = $("#message").val();
                if (!messages) {
                    messages = "abc";
                }
                let recipients = $("#recipients").val();
                let delimiter = $('input[name=delimiter]:checked').val();
                let country_code = $("#country_code").val();
                let sms_type = $("#sms_type").val();
                let sender_id = $("#sender_id").val();
                let phone_number = $("#phone_number").val();

                if (sending_server != '' && recipients != '') {
                    $.ajax({
                        url: "<?php echo e(url('/sms/quick-send/calculate')); ?>",
                        type: "POST",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            sending_server: sending_server,
                            recipients: recipients,
                            message: messages,
                            delimiter: delimiter,
                            country_code: country_code,
                            sms_type: sms_type,
                            sender_id: sender_id,
                            phone_number: phone_number,
                        },
                        cache: false,
                        success: function (data) {
                            $('.spinner-grow').css('display', 'none');
                            let message = data.message;

                            // Check if the message is a number
                            if (!isNaN(message)) {
                                // Display the message in the element with ID "calculation"
                                $("#calculation").html("Estimated Unit: " + message);
                                $("#calculation").css('color', 'grey');
                                //background color green

                                $("#send_message_button").prop("disabled", false);
                                $("#recalculate").css("display", 'block');


                            } else {
                                $("#calculation").html(message);
                                $("#calculation").css('color', 'red');
                                $("#send_message_button").prop("disabled", true);
                                $("#recalculate").css("display", 'block');

                            }
                        },
                        error: function (data) {
                            $('.spinner-grow').css('display', 'none');
                            $("#calculation").html(data.message);
                            $("#calculation").css('color', 'red');
                            $("#send_message_button").prop("disabled", true);
                            $("#recalculate").css("display", 'block');


                        }
                    });
                }
            }

            // Basic Select2 select
            $(".select2").each(function () {
                let $this = $(this);
                $this.wrap('<div class="position-relative"></div>');
                $this.select2({
                    // the following code is used to disable x-scrollbar when click in select input and
                    // take 100% width in responsive also
                    dropdownAutoWidth: true,
                    width: '100%',
                    dropdownParent: $this.parent()
                });
            });

            let $remaining = $('#remaining'),
                $get_msg = $("#message"),
                $messages = $remaining.next(),
                firstInvalid = $('form').find('.is-invalid').eq(0),
                $get_recipients = $('#recipients'),
                number_of_recipients_ajax = 0,
                number_of_recipients_manual = 0;

            if (firstInvalid.length) {
                $('body, html').stop(true, true).animate({
                    'scrollTop': firstInvalid.offset().top - 200 + 'px'
                }, 200);
            }

            function isArabic(text) {
                let pattern = /[\u0600-\u06FF\u0750-\u077F]/;
                return pattern.test(text);
            }

            function get_character() {
                if ($get_msg[0].value !== null) {

                    let data = SmsCounter.count($get_msg[0].value, true);

                    if (data.encoding === 'UTF16') {
                        $('#sms_type').val('unicode').trigger('change');
                        if (isArabic($(this).val())) {
                            $get_msg.css('direction', 'rtl');
                        }
                    } else {
                        $('#sms_type').val('plain').trigger('change');
                        $get_msg.css('direction', 'ltr');
                    }

                    $remaining.text(data.remaining + " <?php echo __('locale.labels.characters_remaining'); ?>");
                    $messages.text(data.messages + " <?php echo __('locale.labels.message'); ?>" + '(s)');

                }

            }

            $("#sms_template").on('change', function () {

                let template_id = $(this).val();

                $.ajax({
                    url: "<?php echo e(url('templates/show-data')); ?>" + '/' + template_id,
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    cache: false,
                    success: function (data) {
                        if (data.status === 'success') {
                            const caretPos = $get_msg[0].selectionStart;
                            const textAreaTxt = $get_msg.val();
                            let txtToAdd = data.message;

                            $('#dlt_template_id').val(data.dlt_template_id);

                            $get_msg.val(textAreaTxt.substring(0, caretPos) + txtToAdd + textAreaTxt.substring(caretPos)).val().length;

                            get_character();

                        } else {
                            toastr['warning'](data.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    },
                    error: function (reject) {
                        if (reject.status === 422) {
                            let errors = reject.responseJSON.errors;
                            $.each(errors, function (key, value) {
                                toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                    closeButton: true,
                                    positionClass: 'toast-top-right',
                                    progressBar: true,
                                    newestOnTop: true,
                                    rtl: isRtl
                                });
                            });
                        } else {
                            toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    }
                });
            });

            $get_msg.on('change keyup paste', get_character);

            function get_delimiter() {
                return $('input[name=delimiter]:checked').val();
            }

            function get_recipients_count() {

                let recipients_value = $get_recipients[0].value.trim();

                if (recipients_value) {
                    let delimiter = get_delimiter();

                    if (delimiter === ';') {
                        number_of_recipients_manual = recipients_value.split(';').length;
                    } else if (delimiter === ',') {
                        number_of_recipients_manual = recipients_value.split(',').length;
                    } else if (delimiter === '|') {
                        number_of_recipients_manual = recipients_value.split('|').length;
                    } else if (delimiter === 'tab') {
                        number_of_recipients_manual = recipients_value.split(' ').length;
                    } else if (delimiter === 'new_line') {
                        number_of_recipients_manual = recipients_value.split('\n').length;
                    } else {
                        number_of_recipients_manual = 0;
                    }
                } else {
                    number_of_recipients_manual = 0;
                }
                let total = number_of_recipients_manual + Number(number_of_recipients_ajax);

                $('.number_of_recipients').text(total);
            }

            $get_recipients.keyup(get_recipients_count);

            $("input[name='delimiter']").change(function () {
                get_recipients_count();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/Campaigns/quickSend.blade.php ENDPATH**/ ?>