<?php if(isset($configData["mainLayoutType"]) && $configData["mainLayoutType"] == 'horizontal'): ?>
    <nav class="header-navbar navbar-expand-lg navbar navbar-fixed align-items-center navbar-shadow navbar-brand-center <?php echo e($configData['navbarColor']); ?>" data-nav="brand-center" >
        <div class="navbar-header d-xl-block d-none">
            <ul class="nav navbar-nav">
                <?php if(Auth::user()->active_portal == 'customer' && Auth::user()->is_customer == 1 && Auth::user()->customer->activeSubscription()): ?>
                    <li class="nav-item"><a class="navbar-brand" href="<?php echo e(route('user.home')); ?>">
                            <span class="brand-logo"><img src="<?php echo e(asset(config('app.logo'))); ?>" alt="app logo"/></span>
                        </a>
                    </li>
                <?php else: ?>
                    <li class="nav-item"><a class="navbar-brand" href="<?php echo e(route('admin.home')); ?>">
                            <span class="brand-logo"><img src="<?php echo e(asset(config('app.logo'))); ?>" alt="app logo"/></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
        <?php else: ?>
            <nav class="header-navbar navbar navbar-expand-lg align-items-center <?php echo e($configData['navbarClass']); ?> navbar-light navbar-shadow <?php echo e($configData['navbarColor']); ?> <?php echo e($configData['layoutWidth'] === 'boxed' && $configData['verticalMenuNavbarType'] === 'navbar-floating' ? 'container-xxl' : ''); ?>" style="    background-image: linear-gradient(85deg,#2F0D6E,#8A0A8B);
}">
                <?php endif; ?>


                <div class="navbar-container d-flex content">
                    <div class="bookmark-wrapper d-flex align-items-center">
                        <ul class="nav navbar-nav d-xl-none">
                            <li class="nav-item"><a class="nav-link menu-toggle" href="javascript:void(0);"><i class="ficon" data-feather="menu"></i></a></li>
                        </ul>
                    </div>


                    <ul class="nav navbar-nav align-items-center ms-auto">
                        
                        <li class="nav-item dropdown dropdown-language">
                            <a class="nav-link dropdown-toggle" id="dropdown-flag" href="#" data-bs-toggle="dropdown" aria-haspopup="true">
                                <i class="flag-icon flag-icon-us"></i>
                                <span class="selected-language">English</span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-flag">
                                <?php $__currentLoopData = \App\Helpers\Helper::languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="dropdown-item" href="<?php echo e(url('lang/'.$lang['code'])); ?>" data-language="<?php echo e($lang['code']); ?>">
                                        <i class="flag-icon flag-icon-<?php echo e($lang['iso_code']); ?>"></i> <?php echo e($lang['name']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </li>

                        
                        
                        
                        

                        
                        <li class="nav-item dropdown dropdown-notification me-25">
                            <a class="nav-link" href="javascript:void(0);" data-bs-toggle="dropdown">
                                <i class="ficon" data-feather="bell"></i>
                                <?php
                                    $count = \App\Models\Notifications::where('user_id', Auth::user()->id)->where('mark_read', 0)->count();
                                ?>
                                <?php if($count): ?>
                                    <span class="badge rounded-pill bg-danger badge-up"><?php echo e($count); ?></span>
                                <?php endif; ?>

                            </a>
                            <ul class="dropdown-menu dropdown-menu-media dropdown-menu-end">
                                <li class="dropdown-menu-header">
                                    <div class="dropdown-header d-flex">
                                        <h4 class="notification-title mb-0 me-auto"><?php echo e(__('locale.labels.notifications')); ?></h4>
                                        <div class="badge rounded-pill badge-light-primary"><?php echo e($count); ?> <?php echo e(__('locale.labels.new')); ?></div>
                                    </div>
                                </li>
                                <li class="scrollable-container media-list">

                                    <?php $__currentLoopData = \App\Models\Notifications::where('user_id', Auth::user()->id)->where('mark_read', 0)->latest()->take('10')->cursor(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <a class="d-flex" href="<?php echo e(route('user.account', ['tab' => 'notification'])); ?>">
                                            <div class="list-item d-flex align-items-start">
                                                <?php switch($value->notification_type):

                                                    case ('user'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-primary">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="user"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder"><?php echo e(__('locale.labels.you_have_new_user')); ?></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 30)); ?></small>
                                                        </div>
                                                        <?php break; ?>

                                                    <?php case ('plan'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-success">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="shopping-cart"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder"><?php echo e(__('locale.labels.you_have_new_subscription')); ?></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 30)); ?></small>
                                                        </div>

                                                        <?php break; ?>

                                                    <?php case ('senderid'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-danger">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="user-check"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder"><?php echo e(__('locale.labels.new_sender_id_notification')); ?></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 30)); ?></small>
                                                        </div>
                                                        <?php break; ?>

                                                    <?php case ('number'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-info">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="phone"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder">New Number sales</span></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 30)); ?></small>
                                                        </div>
                                                        <?php break; ?>

                                                    <?php case ('keyword'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-warning">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="clipboard"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder">New Keyword sales</span></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 30)); ?></small>
                                                        </div>
                                                        <?php break; ?>

                                                    <?php case ('chatbox'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-danger">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="message-square"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder">New Inbox Message</span></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 30)); ?></small>
                                                        </div>
                                                        <?php break; ?>


                                                    <?php case ('subscription'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-danger">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="shopping-cart"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder">Subscription Expired!</span></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 60)); ?></small>
                                                        </div>
                                                        <?php break; ?>

                                                    <?php case ('smsunit'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-danger">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="message-square"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder">SMS Unit Running Low!</span></p>
                                                            <small class="notification-text"> <?php echo e(str_limit($value->message, 60)); ?></small>
                                                        </div>
                                                        <?php break; ?>

                                                    <?php case ('topup'): ?>
                                                        <div class="me-1">
                                                            <div class="avatar bg-light-danger">
                                                                <div class="avatar-content"><i class="avatar-icon" data-feather="shopping-cart"></i></div>
                                                            </div>
                                                        </div>

                                                        <div class="list-item-body flex-grow-1">
                                                            <p class="media-heading"><span class="fw-bolder">Offline Topup Payment!</span></p>
                                                            <small class="notification-text"><?php echo e(str_limit($value->message, 60)); ?></small>
                                                        </div>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                                <small>
                                                    <time class="media-meta"><?php echo e(\App\Library\Tool::formatHumanTime($value->created_at)); ?></time>
                                                </small>

                                            </div>
                                        </a>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </li>
                                <li class="dropdown-menu-footer">
                                    <a class="btn btn-primary w-100" href="<?php echo e(route('user.account', ['tab' => 'notification'])); ?>"><?php echo e(__('locale.labels.read_all_notifications')); ?></a>
                                </li>
                            </ul>
                        </li>


                        <?php if(Auth::user()->active_portal == 'customer' && Auth::user()->is_customer == 1 ): ?>
                            <li class="nav-item balance-top-up">
                                <div class="show-balance">
                                    <span class="show-balance-text"><?php echo e(__('locale.labels.balance')); ?></span>
                                    <span class="show-balance-unit"><?php echo e(Auth::user()->sms_unit == '-1' ? __('locale.labels.unlimited') : \App\Library\Tool::format_price(Auth::user()->sms_unit, Auth::user()->customer->subscription->plan->currency->format)); ?></span>
                                </div>
                                <a class="nav-link top-up-url d-sm-block" href="<?php echo e(route('user.account.top_up')); ?>">
                                    <button type="button" class="btn btn-sm btn-outline-success">
                                        <span class="font-weight-bold" style="font-size: 12px"><?php echo e(__('locale.labels.top_up')); ?></span>
                                    </button>
                                </a>
                            </li>
                        <?php endif; ?>


                        <li class="dropdown dropdown-user nav-item">
                            <a class="dropdown-toggle nav-link dropdown-user-link" id="dropdown-user" href="javascript:void(0);" data-bs-toggle="dropdown" aria-haspopup="true">
                                <div class="user-nav d-sm-flex d-none">
                            <span class="user-name fw-bolder">
                                <?php if(Auth::check()): ?>
                                    <?php echo e(Auth::user()->displayName()); ?>

                                <?php else: ?>
                                    <?php echo e(config('app.name')); ?>

                                <?php endif; ?>
                            </span>
                                    <span class="user-status"><?php echo e(__('locale.labels.available')); ?></span>
                                </div>
                                <span class="avatar">
                            <img class="round" src="<?php echo e(route('user.avatar', Auth::user()->uid)); ?>" alt="<?php echo e(config('app.name')); ?>" height="40" width="40"/>
                        </span>
                            </a>

                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-user">
                                <?php if(Auth::user()->active_portal == 'admin' && Auth::user()->is_customer == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('user.switch_view', ['portal' => 'customer'])); ?>"><i class="me-50" data-feather="log-in"></i><?php echo e(__('locale.labels.switch_view')); ?></a>
                                    <div class="dropdown-divider"></div>
                                <?php endif; ?>

                                <?php if(Auth::user()->active_portal == 'customer' && Auth::user()->is_admin == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('user.switch_view', ['portal' => 'admin'])); ?>"><i class="me-50" data-feather="log-in"></i><?php echo e(__('locale.labels.switch_view')); ?></a>
                                    <div class="dropdown-divider"></div>
                                <?php endif; ?>

                                <h6 class="dropdown-header"><?php echo e(__('locale.labels.manage_profile')); ?></h6>
                                <div class="dropdown-divider"></div>

                                <a class="dropdown-item" href="<?php echo e(route('user.account')); ?>"><i class="me-50" data-feather="user"></i><?php echo e(__('locale.labels.profile')); ?></a>

                                <?php if(Auth::user()->active_portal == 'customer' && Auth::user()->is_customer == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('customer.subscriptions.index')); ?>">
                                        <i class="me-50" data-feather="shopping-cart"></i>
                                        <?php echo e(__('locale.labels.billing')); ?>

                                    </a>

                                    <a class="dropdown-item" href="<?php echo e(route('user.account.pricing')); ?>">
                                        <i class="me-50" data-feather="tag"></i>
                                        <?php echo e(__('locale.plans.pricing')); ?>

                                    </a>
                                <?php endif; ?>

                                <div class="dropdown-divider"></div>

                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><i class="me-50" data-feather="power"></i> <?php echo e(__('locale.menu.Logout')); ?></a>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                    <?php echo e(csrf_field()); ?>

                                </form>
                            </div>
                        </li>
                    </ul>
                </div>

            </nav>
            <!-- END: Header-->
<?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/panels/navbar.blade.php ENDPATH**/ ?>