<?php use App\Library\Tool; ?>


<?php $__env->startSection('title', __('locale.menu.Campaign Builder')); ?>

<?php $__env->startSection('vendor-style'); ?>
    <!-- vendor css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/wizard/bs-stepper.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/select/select2.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/pickers/flatpickr/flatpickr.min.css'))); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/forms/form-wizard.css'))); ?>">

    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/plugins/forms/pickers/form-flat-pickr.css'))); ?>">

    <style>
        .customized_select2 .select2-selection--multiple {
            border-left: 0;
            border-radius: 0 4px 4px 0;
            min-height: 2.75rem !important;
        }

        .customized_select2 .select2-selection--single, .input_sender_id {
            border-left: 0;
            border-radius: 0 4px 4px 0;
            min-height: 2.75rem !important;
        }

        .rounded-text {
            border-radius: 25px;
            padding: 10px;
            background: #f2f2f2;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Basic Vertical form layout section start -->
    <section class="modern-horizontal-wizard">
        
        
        
        
        

        <form class="form form-vertical" action="<?php echo e(route('customer.sms.campaign_builder')); ?>"
              method="post">
            <?php echo csrf_field(); ?>
            <div class="bs-stepper wizard-modern modern-wizard-example">
                <div class="bs-stepper-header">
                    <!-- Step 1: Who -->
                    <div class="step" data-target="#who-part">
                        <button type="button" class="step-trigger">
                            <span class="bs-stepper-circle">1</span>
                            <span class="bs-stepper-label"><?php echo e(__('locale.campaigns.who')); ?></span>
                        </button>
                    </div>
                    <div class="line">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none"
                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                             class="feather feather-chevron-right font-medium-2">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </div>
                    <!-- Step 2: What -->
                    <div class="step" data-target="#what-part">
                        <button type="button" class="step-trigger">
                            <span class="bs-stepper-circle">2</span>
                            <span class="bs-stepper-label"><?php echo e(__('locale.campaigns.what')); ?></span>
                        </button>
                    </div>
                    <div class="line">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none"
                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                             class="feather feather-chevron-right font-medium-2">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </div>
                    <!-- Step 3: When -->
                    <div class="step" data-target="#when-part">
                        <button type="button" class="step-trigger">
                            <span class="bs-stepper-circle">3</span>
                            <span class="bs-stepper-label"><?php echo e(__('locale.campaigns.when')); ?></span>
                        </button>
                    </div>
                    <div class="line">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none"
                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                             class="feather feather-chevron-right font-medium-2">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </div>
                    <!-- Step 4: Review -->
                    <div class="step" data-target="#review-part">
                        <button type="button" class="step-trigger">
                            <span class="bs-stepper-circle">4</span>
                            <span class="bs-stepper-label"><?php echo e(__('locale.campaigns.review')); ?></span>
                        </button>
                    </div>
                </div>
                <div class="bs-stepper-content">
                    <!-- Your step content -->
                    <div id="who-part" class="content" role="tabpanel" aria-labelledby="cart-trigger">
                        <div class="mb-1">
                            <label for="name"
                                   class="required form-label"><?php echo e(__('locale.labels.name')); ?></label>
                            <input type="text"
                                   id="name"
                                   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('name')); ?>"
                                   name="name" required
                                   placeholder="<?php echo e(__('locale.labels.required')); ?>" autofocus>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p><small class="text-danger"><?php echo e($message); ?></small></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <?php if($sendingServers->count() > 0): ?>
                            <div class="mb-1" style="display: none">
                                <label for="sending_server"
                                       class="form-label required"><?php echo e(__('locale.labels.sending_server')); ?></label>
                                <select class="select2 form-select rate-calculate-quicksend"
                                        name="sending_server" id="sending_server">
                                    <?php $__currentLoopData = $sendingServers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($server->sendingServer->plain): ?>
                                            <option value="<?php echo e($server->sendingServer->id); ?>"> <?php echo e($server->sendingServer->name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <?php $__errorArgs = ['sending_server'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_sender_id')): ?>
                            <?php if(auth()->user()->customer->getOption('sender_id_verification') == 'yes'): ?>
                                <div class="col-12">
                                    <p class="text-uppercase"><?php echo e(__('locale.labels.originator')); ?></p>
                                </div>
                                <div class="col-md-6 col-12 customized_select2">
                                    <div class="mb-1">
                                        <label for="sender_id_check"
                                               class="form-label"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                        <div class="input-group">
                                            <div class="input-group-text">
                                                <div class="form-check">
                                                    <input type="radio"
                                                           class="form-check-input sender_id"
                                                           name="originator"
                                                           checked
                                                           value="sender_id"
                                                           id="sender_id_check"/>
                                                    <label class="form-check-label"
                                                           for="sender_id_check"></label>
                                                </div>
                                            </div>

                                            <div style="width: 17rem">
                                                <select class="form-select select2"
                                                        id="sender_id"
                                                        name="sender_id[]">
                                                    <?php $__currentLoopData = $sender_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sender_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($sender_id->sender_id); ?>"> <?php echo e($sender_id->sender_id); ?> </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_numbers')): ?>
                                    <div class="col-md-6 col-12 customized_select2">

                                        <div class="mb-1">
                                            <label for="sender_id"
                                                   class="form-label"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <div class="form-check">
                                                        <input type="radio"
                                                               class="form-check-input sender_id"
                                                               name="originator"
                                                               checked
                                                               value="sender_id"
                                                               id="sender_id_check"/>
                                                        <label class="form-check-label"
                                                               for="sender_id_check"></label>
                                                    </div>
                                                </div>

                                                <div style="width: 17rem">
                                                    <input type="text"
                                                           id="sender_id"
                                                           class="form-control input_sender_id <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                           name="sender_id[]">
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                <?php else: ?>
                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label for="sender_id"
                                                   class="form-label"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                            <input type="text"
                                                   id="sender_id"
                                                   class="form-control <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                   name="sender_id[]">
                                            <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_numbers')): ?>
                            <div class="col-md-6 col-12 customized_select2">
                                <div class="mb-1">
                                    <label for="phone_number"
                                           class="form-label"><?php echo e(__('locale.menu.Phone Numbers')); ?></label>
                                    <div class="input-group">
                                        <div class="input-group-text">
                                            <div class="form-check">
                                                <input type="radio"
                                                       class="form-check-input phone_number rate-calculate-quicksend"
                                                       value="phone_number"
                                                       name="originator"
                                                       id="phone_number_check"/>
                                                <label class="form-check-label"
                                                       for="phone_number_check"></label>
                                            </div>
                                        </div>

                                        <div style="width: 17rem">
                                            <select class="form-select select2 rate-calculate-quicksend"
                                                    disabled
                                                    id="phone_number"
                                                    name="phone_number[]">
                                                <?php $__currentLoopData = $phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($number->number); ?>"> <?php echo e($number->number); ?> </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="mb-1">
                            <label for="contact_groups"
                                   class="form-label"><?php echo e(__('locale.contacts.contact_groups')); ?></label>
                            <select class="select2 form-select rate-calculate-quicksend"
                                    name="contact_groups[]"
                                    multiple="multiple"
                                    id="contact_groups">
                                <?php $__currentLoopData = $contact_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($group->id); ?>"> <?php echo e($group->name); ?>

                                        (<?php echo e(Tool::number_with_delimiter($group->subscribersCount($group->cache))); ?> <?php echo e(__('locale.menu.Contacts')); ?>

                                        )
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <?php $__errorArgs = ['contact_groups'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="d-flex justify-content-between">
                            <button class="btn btn-outline-secondary btn-prev" disabled>
                                <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                            </button>
                            <button class="btn btn-primary btn-next" type="button">
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.next')); ?></span>
                                <i data-feather="arrow-right"
                                   class="align-middle ms-sm-25 ms-0"></i>
                            </button>
                        </div>

                    </div>
                    <!-- Step 2: What -->
                    <div id="what-part" class="content" role="tabpanel" aria-labelledby="cart-trigger">
                        <div class="mb-1">
                            <label class="sms_template form-label"
                                   for="sms_template"><?php echo e(__('locale.permission.sms_template')); ?></label>
                            <select class="form-select select2 rate-calculate-quicksend"
                                    id="sms_template">
                                <option><?php echo e(__('locale.labels.select_one')); ?></option>
                                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($template->id); ?>"><?php echo e($template->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>

                        <div class="mb-1">
                            <label class="form-label"
                                   for="available_tag"><?php echo e(__('locale.labels.available_tag')); ?></label>
                            <select class="form-select select2 rate-calculate-quicksend"
                                    id="available_tag">
                                <option value="phone"><?php echo e(__('locale.labels.phone')); ?></option>
                                <option value="first_name"><?php echo e(__('locale.labels.first_name')); ?></option>
                                <option value="last_name"><?php echo e(__('locale.labels.last_name')); ?></option>
                                <option value="email"><?php echo e(__('locale.labels.email')); ?></option>
                                <option value="username"><?php echo e(__('locale.labels.username')); ?></option>
                                <option value="company"><?php echo e(__('locale.labels.company')); ?></option>
                                <option value="address"><?php echo e(__('locale.labels.address')); ?></option>
                                <option value="birth_date"><?php echo e(__('locale.labels.birth_date')); ?></option>
                                <option value="anniversary_date"><?php echo e(__('locale.labels.anniversary_date')); ?></option>

                                <?php if($template_tags): ?>
                                    <?php $__currentLoopData = $template_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($field->tag); ?>"><?php echo e($field->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <?php if(config('app.trai_dlt')): ?>
                            <div class="mb-1">
                                <label for="dlt_template_id"
                                       class="form-label required"><?php echo e(__('locale.templates.dlt_template_id')); ?></label>
                                <input type="text"
                                       id="dlt_template_id"
                                       class="form-control <?php $__errorArgs = ['dlt_template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       name="dlt_template_id"
                                       required>
                                <?php $__errorArgs = ['dlt_template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                </p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>
                        <div class="mb-1">
                            <label for="message"
                                   class="required form-label"><?php echo e(__('locale.labels.message')); ?></label>
                            <textarea
                                    class="form-control rate-calculate-quicksend"
                                    name="message"
                                    rows="5"
                                    id="message"></textarea>
                            <div class="d-flex justify-content-between">
                                <small class="text-primary text-uppercase text-start"
                                       id="remaining">160 <?php echo e(__('locale.labels.characters_remaining')); ?></small>
                                <small class="text-primary text-uppercase text-end"
                                       id="messages">1 <?php echo e(__('locale.labels.message')); ?>

                                    (s)</small>
                            </div>
                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            <button class="btn btn-outline-secondary btn-prev" type="button">
                                <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                            </button>
                            <button class="btn btn-primary btn-next" type="button">
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.next')); ?></span>
                                <i data-feather="arrow-right"
                                   class="align-middle ms-sm-25 ms-0"></i>
                            </button>
                        </div>
                    </div>
                    <!-- Step 3: When -->
                    <div id="when-part" class="content" role="tabpanel" aria-labelledby="cart-trigger">
                        <div class="row">
                            <div class="col-12">
                                <div class="mb-1">
                                    <div class="form-check form-check-inline">
                                        <input type="checkbox" id="schedule"
                                               class="form-check-input schedule"
                                               value="true"
                                               name="schedule" checked>
                                        <label class="form-check-label"
                                               for="schedule"><?php echo e(__('locale.campaigns.schedule_campaign')); ?>

                                            ?</label>
                                    </div>
                                    <p>
                                        <small class="text-primary px-2"><?php echo e(__('locale.campaigns.schedule_campaign_note')); ?></small>
                                    </p>
                                </div>
                            </div>

                        </div>

                        <div class="row schedule_time">
                            <div class="col-md-6">
                                <div class="mb-1">
                                    <label for="schedule_date"
                                           class="form-label"><?php echo e(__('locale.labels.date')); ?></label>
                                    <input type="text" id="schedule_date"
                                           name="schedule_date"
                                           class="form-control schedule_date"
                                           placeholder="YYYY-MM-DD"/>
                                    <?php $__errorArgs = ['schedule_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <small class="text-danger"><?php echo e($message); ?></small>
                                    </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-1">
                                    <label for="time"
                                           class="form-label"><?php echo e(__('locale.labels.time')); ?></label>
                                    <input type="text" id="time"
                                           class="form-control flatpickr-time text-start"
                                           name="schedule_time"
                                           placeholder="HH:MM"/>
                                    <?php $__errorArgs = ['schedule_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <small class="text-danger"><?php echo e($message); ?></small>
                                    </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="mb-1">
                                    <label for="timezone"
                                           class="form-label"><?php echo e(__('locale.labels.timezone')); ?></label>
                                    <select class="form-select select2"
                                            id="timezone" name="timezone">
                                        <?php $__currentLoopData = Tool::allTimeZones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($timezone['zone']); ?>" <?php echo e(Auth::user()->timezone == $timezone['zone'] ? 'selected': null); ?>> <?php echo e($timezone['text']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['timezone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <small class="text-danger"><?php echo e($message); ?></small>
                                    </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="mb-1">
                                    <label for="frequency_cycle"
                                           class="form-label"><?php echo e(__('locale.labels.frequency')); ?></label>
                                    <select class="form-select"
                                            id="frequency_cycle"
                                            name="frequency_cycle">
                                        <option value="onetime" <?php echo e(old('frequency_cycle')); ?>> <?php echo e(__('locale.labels.one_time')); ?></option>
                                        <option value="daily" <?php echo e(old('frequency_cycle')); ?>> <?php echo e(__('locale.labels.daily')); ?></option>
                                        <option value="monthly" <?php echo e(old('frequency_cycle')); ?>> <?php echo e(__('locale.labels.monthly')); ?></option>
                                        <option value="yearly" <?php echo e(old('frequency_cycle')); ?>> <?php echo e(__('locale.labels.yearly')); ?></option>
                                        <option value="custom" <?php echo e(old('frequency_cycle')); ?>> <?php echo e(__('locale.labels.custom')); ?></option>
                                    </select>
                                </div>
                                <?php $__errorArgs = ['frequency_cycle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                </p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-sm-6 col-12 show-custom">
                                <div class="mb-1">
                                    <label for="frequency_amount"
                                           class="form-label"><?php echo e(__('locale.plans.frequency_amount')); ?></label>
                                    <input type="text"
                                           id="frequency_amount"
                                           class="form-control text-right <?php $__errorArgs = ['frequency_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           name="frequency_amount"
                                           value="<?php echo e(old('frequency_amount')); ?>"
                                    >
                                    <?php $__errorArgs = ['frequency_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <small class="text-danger"><?php echo e($message); ?></small>
                                    </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-sm-6 col-12 show-custom">
                                <div class="mb-1">
                                    <label for="frequency_unit"
                                           class="form-label"><?php echo e(__('locale.plans.frequency_unit')); ?></label>
                                    <select class="form-select"
                                            id="frequency_unit"
                                            name="frequency_unit">
                                        <option value="day" <?php echo e(old('frequency_unit')); ?>> <?php echo e(__('locale.labels.day')); ?></option>
                                        <option value="week" <?php echo e(old('frequency_unit')); ?>> <?php echo e(__('locale.labels.week')); ?></option>
                                        <option value="month" <?php echo e(old('frequency_unit')); ?>> <?php echo e(__('locale.labels.month')); ?></option>
                                        <option value="year" <?php echo e(old('frequency_unit')); ?>> <?php echo e(__('locale.labels.year')); ?></option>
                                    </select>
                                </div>
                                <?php $__errorArgs = ['frequency_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                </p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 show-recurring">
                                <div class="mb-1">
                                    <label for="recurring_date"
                                           class="form-label"> <?php echo e(__('locale.labels.end_date')); ?></label>
                                    <input type="text" id="recurring_date"
                                           name="recurring_date"
                                           class="form-control schedule_date"
                                           placeholder="YYYY-MM-DD"/>
                                    <?php $__errorArgs = ['recurring_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <small class="text-danger"><?php echo e($message); ?></small>
                                    </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6 show-recurring">
                                <div class="mb-1">
                                    <label for="recurring_time"
                                           class="form-label"><?php echo e(__('locale.labels.end_time')); ?></label>
                                    <input type="text" id="recurring_time"
                                           class="form-control flatpickr-time text-start"
                                           name="recurring_time"
                                           placeholder="HH:MM"/>
                                    <?php $__errorArgs = ['recurring_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <small class="text-danger"><?php echo e($message); ?></small>
                                    </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="mb-1">
                                    <div class="form-check form-check-inline">
                                        <input type="checkbox" id="advanced"
                                               name="advanced"
                                               class="form-check-input advanced"
                                               value="true">
                                        <label class="form-check-label"
                                               for="advanced"><?php echo e(__('locale.labels.advanced')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row advanced_div">
                            <div class="col-12">
                                <div class="mb-1">
                                    <div class="form-check form-check-inline">
                                        <input type="checkbox"
                                               id="send_copy" value="true"
                                               name="send_copy"
                                               class="form-check-input">
                                        <label class="form-check-label"
                                               for="send_copy"><?php echo e(__('locale.campaigns.send_copy_via_email')); ?></label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="mb-1">
                                    <div class="form-check form-check-inline">
                                        <input type="checkbox"
                                               id="create_template"
                                               value="true"
                                               name="create_template"
                                               class="form-check-input">
                                        <label class="form-check-label"
                                               for="create_template"><?php echo e(__('locale.campaigns.create_template_based_message')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between">
                            <button class="btn btn-outline-secondary btn-prev" type="button">
                                <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                            </button>
                            <button class="btn btn-primary btn-next" type="button">
                                <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.next')); ?></span>
                                <i data-feather="arrow-right"
                                   class="align-middle ms-sm-25 ms-0"></i>
                            </button>
                        </div>
                    </div>
                    <!-- Step 4: Review -->
                    <div id="review-part" class="content" role="tabpanel" aria-labelledby="cart-trigger">
                        <div class="text-center">
                            <div class="spinner-grow float-right"
                                 role="status" style="display: none">
                            </div>
                        </div>
                        <div class="row">
                            
                            <div class="d-flex justify-content-between">
                                <button class="btn btn-outline-secondary btn-prev" type="button">
                                    <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                    <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.previous')); ?></span>
                                </button>
                                <button class="btn btn-primary btn-next" disabled>
                                    <span class="align-middle d-sm-inline-block d-none"><?php echo e(__('locale.datatables.next')); ?></span>
                                    <i data-feather="arrow-right"
                                       class="align-middle ms-sm-25 ms-0"></i>
                                </button>
                            </div>
                            <div class="col-8">
                                <div class=" text-center">
                                    <div class="card-body">
                                        <p id="calculation" class="rounded-text">Complete the Campaign</p>
                                    </div>
                                </div>

                            </div>
                            <div class="col-4">
                                <a href="#"
                                   id="recalculateLink" class="btn btn-secondary mt-2">Recalculate</a>
                            </div>
                            <div class="col-12">
                                <input type="hidden" value="plain"
                                       name="sms_type" id="sms_type">
                                <input type="hidden" value="<?php echo e($plan_id); ?>"
                                       id="plan_id" name="plan_id">
                                <button type="submit"
                                        id="send_message_button"
                                        class="btn btn-primary mt-1 mb-1 float-end"
                                        disabled><i
                                            data-feather="send"></i> <?php echo e(__('locale.buttons.send')); ?>

                                </button>
                            </div>
                            <div class="col-4 " id="recalculate"
                                 style="display: none">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            


            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
        </form>

    </section>
    <!-- // Basic Vertical form layout section end -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <!-- vendor files -->
    <script src="<?php echo e(asset(mix('vendors/js/forms/wizard/bs-stepper.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/forms/select/select2.full.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/pickers/flatpickr/flatpickr.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('js/scripts/dom-rules.js'))); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset(mix('js/scripts/forms/form-wizard.js'))); ?>"></script>


    <script src="<?php echo e(asset(mix('js/scripts/sms-counter.js'))); ?>"></script>

    <script>
        $(document).ready(function () {
            let typingTimerQuicksend;
            let doneTypingIntervalQuicksend = 2000; // 2 seconds delay

            $(".rate-calculate-quicksend").on('keyup change', function () {
                clearTimeout(typingTimerQuicksend);
                typingTimerQuicksend = setTimeout(calculateQuickSend, doneTypingIntervalQuicksend);
            });
            $("#recalculateLink").click(function (event) {
                event.preventDefault(); // Prevent default link behavior
                calculateQuickSend(); // Call the calculateQuickSend function
            });

            function calculateQuickSend() {
                $('.spinner-grow').css('display', 'block');
                let sending_server = $('#sending_server').val();
                let messages = $("#message").val();
                if (!messages) {
                    messages = "abc";
                }
                let contact_groups = $("#contact_groups").val();
                let country_code = $("#country_code").val();
                let sms_type = $("#sms_type").val();
                let sender_id = $("#sender_id").val();
                let phone_number = $("#phone_number").val();
                let plan_id = $("#plan_id").val();

                if (sending_server != '' && contact_groups != '') {
                    $.ajax({
                        url: "<?php echo e(url('/sms/campaign-builder/caculate')); ?>",
                        type: "POST",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            sending_server: sending_server,
                            contact_groups: contact_groups,
                            message: messages,
                            country_code: country_code,
                            plan_id: plan_id,
                            sms_type: sms_type,
                            sender_id: sender_id,
                            phone_number: phone_number,
                        },
                        cache: false,
                        success: function (data) {
                            $('.spinner-grow').css('display', 'none');
                            let message = data.message;

                            // Check if the message is a number
                            if (!isNaN(message)) {
                                let currencyFormat = "<?php echo e(str_replace('{PRICE}', '', Auth::user()->customer->subscription->plan->currency->format)); ?>";
                                // Display the message in the element with ID "calculation"
                                $("#calculation").html("Estimated cost: " + currencyFormat + message);
                                $("#calculation").css('color', 'grey');
                                $("#send_message_button").prop("disabled", false);
                                $("#recalculate").css("display", 'block');

                            } else {
                                $("#calculation").html(message);
                                $("#calculation").css('color', 'red');
                                $("#send_message_button").prop("disabled", true);
                                $("#recalculate").css("display", 'block');

                            }
                        },
                        error: function (reject) {
                            $('.spinner-grow').css('display', 'none');
                            ("#calculation").html(data.message);
                            $("#calculation").css('color', 'red');
                            $("#send_message_button").prop("disabled", true);
                            $("#recalculate").css("display", 'block');

                        }
                    });
                }
            }

            $('.schedule_date').flatpickr({
                minDate: "today",
                dateFormat: "Y-m-d",
                defaultDate: "<?php echo e(date('Y-m-d')); ?>",
            });

            $('.flatpickr-time').flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "H:i",
                defaultDate: "<?php echo e(\Carbon\Carbon::now()->setTimezone(config('app.timezone'))->format('H:i')); ?>",
            });

            $(".sender_id").on("click", function () {
                $("#sender_id").prop("disabled", !this.checked);
                $("#phone_number").prop("disabled", this.checked);
            });

            $(".phone_number").on("click", function () {
                $("#phone_number").prop("disabled", !this.checked);
                $("#sender_id").prop("disabled", this.checked);
            });


            let schedule = $('.schedule'),
                scheduleTime = $(".schedule_time");

            if (schedule.prop('checked') === true) {
                scheduleTime.show();
            } else {
                scheduleTime.hide();
            }

            $('.advanced_div').hide();

            schedule.change(function () {
                scheduleTime.fadeToggle();
            });

            $('.advanced').change(function () {
                $('.advanced_div').fadeToggle();
            });

            $.createDomRules({

                parentSelector: 'body',
                scopeSelector: 'form',
                showTargets: function (rule, $controller, condition, $targets) {
                    $targets.fadeIn();
                },
                hideTargets: function (rule, $controller, condition, $targets) {
                    $targets.fadeOut();
                },

                rules: [
                    {
                        controller: '#frequency_cycle',
                        value: 'custom',
                        condition: '==',
                        targets: '.show-custom',
                    },
                    {
                        controller: '#frequency_cycle',
                        value: 'onetime',
                        condition: '!=',
                        targets: '.show-recurring',
                    },
                    {
                        controller: '.message_type',
                        value: 'mms',
                        condition: '==',
                        targets: '.send-mms',
                    }
                ]
            });


            $(".select2").each(function () {
                let $this = $(this);
                $this.wrap('<div class="position-relative"></div>');
                $this.select2({
                    // the following code is used to disable x-scrollbar when click in select input and
                    // take 100% width in responsive also
                    dropdownAutoWidth: true,
                    width: '100%',
                    dropdownParent: $this.parent()
                });
            });

            let $remaining = $('#remaining'),
                $messages = $remaining.next(),
                $get_msg = $("#message"),
                merge_state = $('#available_tag'),
                firstInvalid = $('form').find('.is-invalid').eq(0);

            if (firstInvalid.length) {
                $('body, html').stop(true, true).animate({
                    'scrollTop': firstInvalid.offset().top - 200 + 'px'
                }, 200);
            }

            function isArabic(text) {
                let pattern = /[\u0600-\u06FF\u0750-\u077F]/;
                return pattern.test(text);
            }

            function get_character() {
                if ($get_msg[0].value !== null) {

                    let data = SmsCounter.count($get_msg[0].value, true);

                    if (data.encoding === 'UTF16') {
                        $('#sms_type').val('unicode').trigger('change');
                        if (isArabic($(this).val())) {
                            $get_msg.css('direction', 'rtl');
                        }
                    } else {
                        $('#sms_type').val('plain').trigger('change');
                        $get_msg.css('direction', 'ltr');
                    }

                    $remaining.text(data.remaining + " <?php echo __('locale.labels.characters_remaining'); ?>");
                    $messages.text(data.messages + " <?php echo __('locale.labels.message'); ?>" + '(s)');

                }

            }


            merge_state.on('change', function () {
                const caretPos = $get_msg[0].selectionStart;
                const textAreaTxt = $get_msg.val();
                let txtToAdd = this.value;
                if (txtToAdd) {
                    txtToAdd = '{' + txtToAdd + '}';
                }

                $get_msg.val(textAreaTxt.substring(0, caretPos) + txtToAdd + textAreaTxt.substring(caretPos));
            });


            $("#sms_template").on('change', function () {

                let template_id = $(this).val();

                $.ajax({
                    url: "<?php echo e(url('templates/show-data')); ?>" + '/' + template_id,
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    cache: false,
                    success: function (data) {
                        if (data.status === 'success') {
                            const caretPos = $get_msg[0].selectionStart;
                            const textAreaTxt = $get_msg.val();
                            let txtToAdd = data.message;

                            $('#dlt_template_id').val(data.dlt_template_id);

                            $get_msg.val(textAreaTxt.substring(0, caretPos) + txtToAdd + textAreaTxt.substring(caretPos)).val().length;

                            get_character();

                        } else {
                            toastr['warning'](data.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    },
                    error: function (reject) {
                        if (reject.status === 422) {
                            let errors = reject.responseJSON.errors;
                            $.each(errors, function (key, value) {
                                toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                    closeButton: true,
                                    positionClass: 'toast-top-right',
                                    progressBar: true,
                                    newestOnTop: true,
                                    rtl: isRtl
                                });
                            });
                        } else {
                            toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    }
                });
            });

            $get_msg.keyup(get_character);

            $("#contact_groups").on('change', function () {

                let contact_id = $(this).val();

                if (contact_id === 0) {
                    return false;
                }

                $.ajax({
                    url: "<?php echo e(url('tags/get-data')); ?>" + '/' + contact_id,
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    cache: false,
                    success: function (data) {
                        if (data.status === 'success') {
                            merge_state.empty();
                            $.each(data.contactFields, function (index, field) {
                                merge_state.append('<option value="' + field.tag + '">' + field.label + '</option>');
                            });

                            // Trigger select2 to update the UI
                            merge_state.select2();

                        } else {
                            toastr['warning'](data.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    },
                    error: function (reject) {
                        if (reject.status === 422) {
                            let errors = reject.responseJSON.errors;
                            $.each(errors, function (key, value) {
                                toastr['warning'](value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                    closeButton: true,
                                    positionClass: 'toast-top-right',
                                    progressBar: true,
                                    newestOnTop: true,
                                    rtl: isRtl
                                });
                            });
                        } else {
                            toastr['warning'](reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                                progressBar: true,
                                newestOnTop: true,
                                rtl: isRtl
                            });
                        }
                    }
                });
            });

        });
    </script>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/Campaigns/campaignBuilder.blade.php ENDPATH**/ ?>