<?php if(isset($template)): ?>
    <?php $__env->startSection('title', __('locale.templates.update_template')); ?>
<?php else: ?>
    <?php $__env->startSection('title', __('locale.templates.add_template')); ?>
<?php endif; ?>


<?php $__env->startSection('vendor-style'); ?>
    <!-- vendor css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/select/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Basic Vertical form layout section start -->
    <section id="basic-vertical-layouts">
        <div class="row match-height">
            <div class="col-md-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php if(isset($template)): ?>
                                <?php echo e(__('locale.templates.update_template')); ?>

                            <?php else: ?>
                                <?php echo e(__('locale.templates.add_template')); ?>

                            <?php endif; ?> </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">

                            <?php if(config('app.trai_dlt')): ?>
                                <p><code><?php echo __('locale.templates.dlt_description'); ?></code></p>
                            <?php endif; ?>

                            <form class="form form-vertical" <?php if(isset($template)): ?> action="<?php echo e(route('customer.templates.update',  $template->uid)); ?>" <?php else: ?> action="<?php echo e(route('customer.templates.store')); ?>" <?php endif; ?> method="post">
                                <?php if(isset($template)): ?>
                                    <?php echo e(method_field('PUT')); ?>

                                <?php endif; ?>
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-12">
                                            <div class="mb-1">
                                                <label for="name" class="form-label required"><?php echo e(__('locale.labels.name')); ?></label>
                                                <input type="text" id="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('name',  $template->name ?? null)); ?>" name="name" required placeholder="<?php echo e(__('locale.labels.required')); ?>" autofocus>
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback">
                                                    <?php echo e($message); ?>

                                                </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>


                                        <?php if(config('app.trai_dlt')): ?>
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label for="dlt_template_id" class="form-label required"><?php echo e(__('locale.templates.dlt_template_id')); ?></label>
                                                    <input type="text" id="dlt_template_id" class="form-control <?php $__errorArgs = ['dlt_template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('dlt_template_id',  $template->dlt_template_id ?? null)); ?>" name="dlt_template_id" required placeholder="<?php echo e(__('locale.labels.required')); ?>">
                                                    <?php $__errorArgs = ['dlt_template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback">
                                                        <?php echo e($message); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>


                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label class="form-label required" for="category"><?php echo e(__('locale.labels.category')); ?></label>
                                                    <select class="form-select" id="category" name="dlt_category">
                                                        <option value="promotional" <?php if(isset($template->dlt_category) && $template->dlt_category =='promotional'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.promotional')); ?></option>
                                                        <option value="transactional" <?php if(isset($template->dlt_category) && $template->dlt_category =='transactional'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.transactional')); ?></option>
                                                        <option value="service_explicit" <?php if(isset($template->dlt_category) && $template->dlt_category =='service_explicit'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.service_explicit')); ?></option>
                                                        <option value="service_implicit" <?php if(isset($template->dlt_category) && $template->dlt_category =='service_implicit'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.service_implicit')); ?></option>
                                                    </select>

                                                    <?php $__errorArgs = ['dlt_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label for="sender_id" class="form-label required"><?php echo e(__('locale.labels.sender_id')); ?></label>
                                                    <select class="form-select select2" name="sender_id">
                                                        <?php $__currentLoopData = $sender_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sender_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($sender_id->id); ?>"
                                                                    <?php echo e(isset($template->sender_id) && $template->sender_id == $sender_id->id ? 'selected': null); ?>>
                                                                <?php echo e($sender_id->sender_id); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                                <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <?php if(isset($template)): ?>
                                                <div class="col-12">
                                                    <div class="mb-1">
                                                        <label class="form-label required" for="approved"><?php echo e(__('locale.labels.approve')); ?></label>
                                                        <select class="form-select" id="approved" name="approved">
                                                            <option value="in_review" <?php if($template->approved == 'in_review'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.in_review')); ?></option>
                                                            <option value="approved" <?php if($template->approved == 'approved'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.yes')); ?></option>
                                                            <option value="block" <?php if($template->approved == 'block'): ?> selected <?php endif; ?>><?php echo e(__('locale.labels.no')); ?></option>
                                                        </select>

                                                        <?php $__errorArgs = ['approved'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <p><small class="text-danger"><?php echo e($message); ?></small></p>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>


                                        <div class="col-12">
                                            <div class="mb-1">
                                                <label class="form-label"><?php echo e(__('locale.labels.available_tag')); ?></label>
                                                <select class="form-select select2" id="available_tag">
                                                    <option value="phone"><?php echo e(__('locale.labels.phone')); ?></option>
                                                    <option value="first_name"><?php echo e(__('locale.labels.first_name')); ?></option>
                                                    <option value="last_name"><?php echo e(__('locale.labels.last_name')); ?></option>
                                                    <option value="email"><?php echo e(__('locale.labels.email')); ?></option>
                                                    <option value="username"><?php echo e(__('locale.labels.username')); ?></option>
                                                    <option value="company"><?php echo e(__('locale.labels.company')); ?></option>
                                                    <option value="address"><?php echo e(__('locale.labels.address')); ?></option>
                                                    <option value="birth_date"><?php echo e(__('locale.labels.birth_date')); ?></option>
                                                    <option value="anniversary_date"><?php echo e(__('locale.labels.anniversary_date')); ?></option>

                                                    <?php if($template_tags): ?>
                                                        <?php $__currentLoopData = $template_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($field->tag); ?>"><?php echo e($field->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>


                                        <div class="col-12">
                                            <div class="mb-1">
                                                <label for="message" class="form-label required"><?php echo e(__('locale.labels.message')); ?></label>
                                                <textarea class="form-control" name="message" rows="5" id="message"><?php echo e(old('message',  $template->message ?? null)); ?></textarea>

                                                <small class="text-primary text-uppercase" id="remaining">160 <?php echo e(__('locale.labels.characters_remaining')); ?></small>
                                                <small class="text-primary text-uppercase float-end" id="messages">1 <?php echo e(__('locale.labels.message')); ?> (s)</small>
                                                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback">
                                                    <?php echo e($message); ?>

                                                </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>


                                        <div class="col-12">
                                            <input type="hidden" name="user_id" value="<?php echo e(Auth::user()->id); ?>">
                                            <input type="hidden" name="user_type" value="customer">
                                            <button type="submit" class="btn btn-primary me-1 mb-1"><i data-feather="save"></i> <?php echo e(__('locale.buttons.save')); ?></button>
                                            <button type="reset" class="btn btn-outline-warning mb-1"><i data-feather="refresh-cw"></i> <?php echo e(__('locale.buttons.reset')); ?></button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- // Basic Vertical form layout section end -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <!-- vendor files -->
    <script src="<?php echo e(asset(mix('vendors/js/forms/select/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset(mix('js/scripts/sms-counter.js'))); ?>"></script>
    <script>
        $(document).ready(function () {

            // Basic Select2 select
            $(".select2").each(function () {
                let $this = $(this);
                $this.wrap('<div class="position-relative"></div>');
                $this.select2({
                    // the following code is used to disable x-scrollbar when click in select input and
                    // take 100% width in responsive also
                    dropdownAutoWidth: true,
                    width: '100%',
                    dropdownParent: $this.parent()
                });
            });


            let $remaining = $('#remaining'),
                $messages = $remaining.next(),
                $get_msg = $("#message"),
                merge_state = $('#available_tag'),
                firstInvalid = $('form').find('.is-invalid').eq(0);

            if (firstInvalid.length) {
                $('body, html').stop(true, true).animate({
                    'scrollTop': firstInvalid.offset().top - 200 + 'px'
                }, 200);
            }

            function get_character() {
                if ($get_msg[0].value !== null) {
                    let data = SmsCounter.count($get_msg[0].value, true);
                    $remaining.text(data.remaining + " <?php echo __('locale.labels.characters_remaining'); ?>");
                    $messages.text(data.messages + " <?php echo __('locale.labels.message'); ?>" + '(s)');
                }
            }

            merge_state.on('change', function () {
                const caretPos = $get_msg[0].selectionStart;
                const textAreaTxt = $get_msg.val();
                let txtToAdd = this.value;
                if (txtToAdd) {
                    txtToAdd = '{' + txtToAdd + '}';
                }

                $get_msg.val(textAreaTxt.substring(0, caretPos) + txtToAdd + textAreaTxt.substring(caretPos));
            });

            $get_msg.keyup(get_character);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appdemo/public_html/clix/app3/resources/views/customer/Templates/create.blade.php ENDPATH**/ ?>