<?php

namespace App\Http\Requests\Customer;

use Illuminate\Foundation\Http\FormRequest;

class AddUnitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
                'add_unit' => 'required|numeric|min:0',
                'plan_id' => 'required',
        ];
    }
    
    public function messages(): array
    {
        return [
            'plan_id.required' => 'Please select Plan.',
        ];
    }
}
