<?php

namespace App\Events;

use App\Models\ChatBox;
use App\Models\User;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MessageSent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * user that sent the message
     *
     * @var User
     */
    public User $user;

    /**
     * @var ChatBox
     */
    public ChatBox $message;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(User $user, ChatBox $message)
    {
        $this->user    = $user;
        $this->message = $message;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return Channel|PrivateChannel
     */
    public function broadcastOn(): Channel|PrivateChannel
    {
        return new PrivateChannel('chat');
    }
}
